/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.OnTheFlyNestedSorter;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneReplaceMissingSortedDocValues;
import org.hibernate.search.backend.lucene.types.sort.impl.SortMissingValue;

public class LuceneTextFieldComparatorSource
extends LuceneFieldComparatorSource {
    private final Object missingValue;

    public LuceneTextFieldComparatorSource(String nestedDocumentPath, Object missingValue) {
        super(nestedDocumentPath);
        this.missingValue = missingValue;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        boolean sortMissingLast = this.missingLast() ^ reversed;
        return new FieldComparator.TermOrdValComparator(numHits, fieldname, sortMissingLast){

            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                SortedDocValues sortedDocValues = super.getSortedDocValues(context, field);
                if (LuceneTextFieldComparatorSource.this.nestedDocsProvider != null) {
                    BitSet parentDocs = LuceneTextFieldComparatorSource.this.nestedDocsProvider.parentDocs(context);
                    DocIdSetIterator childDocs = LuceneTextFieldComparatorSource.this.nestedDocsProvider.childDocs(context);
                    if (parentDocs != null && childDocs != null) {
                        sortedDocValues = OnTheFlyNestedSorter.sort(sortedDocValues, parentDocs, childDocs);
                    }
                }
                if (LuceneTextFieldComparatorSource.this.missingValue == null || LuceneTextFieldComparatorSource.this.missingFirst() || LuceneTextFieldComparatorSource.this.missingLast()) {
                    return sortedDocValues;
                }
                return new LuceneReplaceMissingSortedDocValues(sortedDocValues, (BytesRef)LuceneTextFieldComparatorSource.this.missingValue);
            }
        };
    }

    private boolean missingFirst() {
        return SortMissingValue.MISSING_FIRST.equals(this.missingValue);
    }

    private boolean missingLast() {
        return SortMissingValue.MISSING_LAST.equals(this.missingValue);
    }
}

