/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerTokenizerStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneCharFilterParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenFilterParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenizerParametersStep;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneAnalyzerComponentsStep
implements LuceneAnalyzerTokenizerStep,
LuceneAnalyzerOptionalComponentsStep,
LuceneAnalyzerBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final LuceneTokenizerParametersStep tokenizer;
    private final List<LuceneCharFilterParametersStep> charFilters = new ArrayList<LuceneCharFilterParametersStep>();
    private final List<LuceneTokenFilterParametersStep> tokenFilters = new ArrayList<LuceneTokenFilterParametersStep>();

    LuceneAnalyzerComponentsStep(String name) {
        this.tokenizer = new LuceneTokenizerParametersStep(this);
        this.name = name;
    }

    @Override
    public LuceneAnalyzerOptionalComponentsStep tokenizer(Class<? extends TokenizerFactory> factory) {
        this.tokenizer.factory(factory);
        return this;
    }

    @Override
    public LuceneAnalyzerOptionalComponentsStep param(String name, String value) {
        this.tokenizer.param(name, value);
        return this;
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(Class<? extends CharFilterFactory> factory) {
        LuceneCharFilterParametersStep filter = new LuceneCharFilterParametersStep(this, factory);
        this.charFilters.add(filter);
        return filter;
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(Class<? extends TokenFilterFactory> factory) {
        LuceneTokenFilterParametersStep filter = new LuceneTokenFilterParametersStep(this, factory);
        this.tokenFilters.add(filter);
        return filter;
    }

    @Override
    public Analyzer build(LuceneAnalysisComponentFactory factory) {
        try {
            return factory.createAnalyzer(this.tokenizer.build(factory), (CharFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.charFilters, CharFilterFactory[]::new, factory), (TokenFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.tokenFilters, TokenFilterFactory[]::new, factory));
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCreateAnalyzer(this.name, e);
        }
    }
}

