/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.List;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneNonFlattenedDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;

class LuceneNestedObjectDocumentBuilder
extends AbstractLuceneNonFlattenedDocumentBuilder {
    LuceneNestedObjectDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        super(schemaNode);
    }

    @Override
    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, List<Document> nestedDocuments) {
        this.document.add(MetadataFields.searchableMetadataField(MetadataFields.typeFieldName(), "child"));
        this.document.add(MetadataFields.searchableMetadataField(MetadataFields.rootIndexFieldName(), rootIndexName));
        this.document.add(MetadataFields.retrievableMetadataField(MetadataFields.rootIdFieldName(), rootId));
        this.document.add(MetadataFields.searchableMetadataField(MetadataFields.nestedDocumentPathFieldName(), this.schemaNode.getAbsolutePath()));
        super.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, nestedDocuments);
        nestedDocuments.add(this.document);
    }
}

