/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;

public class LuceneIndexSchemaObjectNode {
    private static final LuceneIndexSchemaObjectNode ROOT = new LuceneIndexSchemaObjectNode(null, null, null, Collections.emptyList(), null, false);
    private final LuceneIndexSchemaObjectNode parent;
    private final String absolutePath;
    private final String nestedDocumentPath;
    private final List<String> childrenAbsolutePaths;
    private final ObjectFieldStorage storage;
    private final boolean multiValued;

    public static LuceneIndexSchemaObjectNode root() {
        return ROOT;
    }

    public LuceneIndexSchemaObjectNode(LuceneIndexSchemaObjectNode parent, String absolutePath, String nestedDocumentPath, List<String> childrenAbsolutePaths, ObjectFieldStorage storage, boolean multiValued) {
        this.parent = parent;
        this.absolutePath = absolutePath;
        this.nestedDocumentPath = nestedDocumentPath;
        this.storage = storage;
        this.multiValued = multiValued;
        this.childrenAbsolutePaths = childrenAbsolutePaths.stream().map(relativeFieldName -> MetadataFields.compose(absolutePath, relativeFieldName)).collect(Collectors.toList());
    }

    public LuceneIndexSchemaObjectNode getParent() {
        return this.parent;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getAbsolutePath(String relativeFieldName) {
        return MetadataFields.compose(this.absolutePath, relativeFieldName);
    }

    public String getNestedDocumentPath() {
        return this.nestedDocumentPath;
    }

    public List<String> getChildrenAbsolutePaths() {
        return this.childrenAbsolutePaths;
    }

    public ObjectFieldStorage getStorage() {
        return this.storage;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absolutePath=" + this.absolutePath + ", storage=" + this.storage + "]";
    }
}

