/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.lowlevel.reader.spi.DirectoryReaderHolder;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class Shard {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneWorkFactory workFactory;
    private final IndexAccessor indexAccessor;
    private final LuceneWriteWorkOrchestratorImplementor writeOrchestrator;

    Shard(LuceneWorkFactory workFactory, IndexAccessor indexAccessor, LuceneWriteWorkOrchestratorImplementor writeOrchestrator) {
        this.workFactory = workFactory;
        this.indexAccessor = indexAccessor;
        this.writeOrchestrator = writeOrchestrator;
    }

    CompletableFuture<?> start() {
        try {
            this.indexAccessor.start();
            this.writeOrchestrator.start();
            return this.writeOrchestrator.ensureIndexExists();
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)this.indexAccessor).push(LuceneWriteWorkOrchestratorImplementor::stop, (Object)this.writeOrchestrator);
            throw log.unableToInitializeIndexDirectory(e.getMessage(), this.indexAccessor.getIndexEventContext(), e);
        }
    }

    CompletableFuture<?> preStop() {
        return this.writeOrchestrator.preStop();
    }

    void stop() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(LuceneWriteWorkOrchestratorImplementor::stop, (Object)this.writeOrchestrator);
            closer.push(IndexAccessor::close, (Object)this.indexAccessor);
        }
    }

    DirectoryReaderHolder openReader() throws IOException {
        return DirectoryReaderHolder.of(this.indexAccessor.openDirectoryIndexReader());
    }

    LuceneWriteWorkOrchestrator getWriteOrchestrator() {
        return this.writeOrchestrator;
    }

    public IndexAccessor getIndexAccessorForTests() {
        return this.indexAccessor;
    }
}

