/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.impl.ShardingStrategyInitializationContextImpl;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.impl.Throwables;

class ShardHolder
implements ReadIndexManagerContext,
WorkExecutionIndexManagerContext {
    private final IndexManagerBackendContext backendContext;
    private final LuceneIndexModel model;
    private BeanHolder<? extends ShardingStrategy> shardingStrategyHolder;
    private final Map<String, Shard> shards = new LinkedHashMap<String, Shard>();
    private final List<LuceneWriteWorkOrchestrator> writeOrchestrators = new ArrayList<LuceneWriteWorkOrchestrator>();

    ShardHolder(IndexManagerBackendContext backendContext, LuceneIndexModel model) {
        this.backendContext = backendContext;
        this.model = model;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[indexName=" + this.model.getIndexName() + "]";
    }

    CompletableFuture<?> start(IndexManagerStartContext startContext) {
        ConfigurationPropertySource propertySource = startContext.getConfigurationPropertySource();
        try {
            ShardingStrategyInitializationContextImpl initializationContext = new ShardingStrategyInitializationContextImpl(this.backendContext, this.model, startContext, propertySource.withMask("sharding"));
            this.shardingStrategyHolder = initializationContext.create(this.shards);
            if (startContext.getFailureCollector().hasFailure()) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture[] futures = new CompletableFuture[this.shards.size()];
            int i = 0;
            for (Shard shard : this.shards.values()) {
                this.writeOrchestrators.add(shard.getWriteOrchestrator());
                futures[i] = shard.start().exceptionally(Futures.handler(e -> {
                    startContext.getFailureCollector().add((Throwable)Throwables.expectException((Throwable)e));
                    return null;
                }));
                ++i;
            }
            return CompletableFuture.allOf(futures);
        }
        catch (RuntimeException e2) {
            new SuppressingCloser((Throwable)e2).pushAll(Shard::stop, this.shards.values());
            this.shards.clear();
            this.writeOrchestrators.clear();
            throw e2;
        }
    }

    CompletableFuture<?> preStop() {
        CompletableFuture[] futures = new CompletableFuture[this.shards.size()];
        int i = 0;
        for (Shard shard : this.shards.values()) {
            futures[i] = shard.preStop();
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }

    void stop() throws IOException {
        try (Closer closer = new Closer();){
            closer.pushAll(Shard::stop, this.shards.values());
            this.shards.clear();
            this.writeOrchestrators.clear();
        }
    }

    @Override
    public void openIndexReaders(Set<String> routingKeys, DirectoryReaderCollector readerCollector) throws IOException {
        String mappedTypeName = this.model.getMappedTypeName();
        Collection<Shard> enabledShards = this.toShards(routingKeys);
        for (Shard shard : enabledShards) {
            readerCollector.collect(mappedTypeName, shard.openReader());
        }
    }

    @Override
    public String getIndexName() {
        return this.model.getIndexName();
    }

    @Override
    public LuceneWriteWorkOrchestrator getWriteOrchestrator(String documentId, String routingKey) {
        return this.toShard(documentId, routingKey).getWriteOrchestrator();
    }

    @Override
    public Collection<LuceneWriteWorkOrchestrator> getAllWriteOrchestrators() {
        return this.writeOrchestrators;
    }

    public List<Shard> getShardsForTests() {
        return new ArrayList<Shard>(this.shards.values());
    }

    private Collection<Shard> toShards(Set<String> routingKeys) {
        if (this.shardingStrategyHolder == null || routingKeys.isEmpty()) {
            return this.shards.values();
        }
        Set<String> shardIdentifiers = ((ShardingStrategy)this.shardingStrategyHolder.get()).toShardIdentifiers(routingKeys);
        HashSet<Shard> enabledShards = new HashSet<Shard>();
        for (String shardId : shardIdentifiers) {
            enabledShards.add(this.shards.get(shardId));
        }
        return enabledShards;
    }

    private Shard toShard(String documentId, String routingKey) {
        if (this.shardingStrategyHolder == null) {
            return this.shards.values().iterator().next();
        }
        String shardId = ((ShardingStrategy)this.shardingStrategyHolder.get()).toShardIdentifier(documentId, routingKey);
        return this.shards.get(shardId);
    }
}

