/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.join.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;

public class NestedDocsProvider {
    private final BitSetProducer parentFiler;
    private final Query childQuery;

    public NestedDocsProvider(String nestedDocumentPath, Query originalParentQuery) {
        this(Collections.singleton(nestedDocumentPath), originalParentQuery);
    }

    public NestedDocsProvider(Set<String> nestedDocumentPaths, Query originalParentQuery) {
        this.parentFiler = new QueryBitSetProducer(originalParentQuery);
        this.childQuery = Queries.findChildQuery(nestedDocumentPaths, originalParentQuery);
    }

    public BitSet parentDocs(LeafReaderContext context) throws IOException {
        return this.parentFiler.getBitSet(context);
    }

    public DocIdSetIterator childDocs(LeafReaderContext context) throws IOException {
        IndexReaderContext topLevelCtx = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
        IndexSearcher indexSearcher = new IndexSearcher(topLevelCtx);
        Weight weight = this.childDocsWeight(indexSearcher);
        return this.childDocs(weight, context);
    }

    public Weight childDocsWeight(IndexSearcher indexSearcher) throws IOException {
        return indexSearcher.createWeight(indexSearcher.rewrite(this.childQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
    }

    public DocIdSetIterator childDocs(Weight weight, LeafReaderContext context) throws IOException {
        Scorer s = weight.scorer(context);
        return s == null ? null : s.iterator();
    }
}

