/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.lowlevel.reader.spi.DirectoryReaderHolder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HolderMultiReader
extends MultiReader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<DirectoryReaderHolder> directoryReaderHolders;
    private final IndexReaderMetadataResolver metadataResolver;

    public static HolderMultiReader open(Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys) {
        if (indexManagerContexts.isEmpty()) {
            return null;
        }
        Builder builder = new Builder();
        try {
            for (ReadIndexManagerContext readIndexManagerContext : indexManagerContexts) {
                readIndexManagerContext.openIndexReaders(routingKeys, builder);
            }
            return builder.build();
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll((Iterable)builder.directoryReaderHolders);
            throw log.failureOnMultiReaderRefresh(EventContexts.fromIndexNames(indexNames), e);
        }
    }

    HolderMultiReader(List<DirectoryReaderHolder> directoryReaderHolders, IndexReaderMetadataResolver metadataResolver) throws IOException {
        super(HolderMultiReader.toReaderArray(directoryReaderHolders), true);
        this.directoryReaderHolders = directoryReaderHolders;
        this.metadataResolver = metadataResolver;
    }

    public String toString() {
        return HolderMultiReader.class.getSimpleName() + " [subReaders=" + this.getSequentialSubReaders() + ", indexReaderHolders=" + this.directoryReaderHolders + "]";
    }

    public IndexReaderMetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    protected synchronized void doClose() throws IOException {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debugf("Closing MultiReader: %s", (Object)this);
        }
        try (Closer closer = new Closer();){
            closer.pushAll(DirectoryReaderHolder::close, this.directoryReaderHolders);
        }
        if (debugEnabled) {
            log.trace("MultiReader closed.");
        }
    }

    private static IndexReader[] toReaderArray(List<DirectoryReaderHolder> directoryReaderHolders) {
        IndexReader[] indexReaders = new IndexReader[directoryReaderHolders.size()];
        for (int i = 0; i < directoryReaderHolders.size(); ++i) {
            indexReaders[i] = directoryReaderHolders.get(i).get();
        }
        return indexReaders;
    }

    public static class Builder
    implements DirectoryReaderCollector {
        private final List<DirectoryReaderHolder> directoryReaderHolders = new ArrayList<DirectoryReaderHolder>();
        private final Map<DirectoryReader, String> mappedTypeNameByDirectoryReader = new HashMap<DirectoryReader, String>();

        private Builder() {
        }

        @Override
        public void collect(String mappedTypeName, DirectoryReaderHolder directoryReaderHolder) {
            this.directoryReaderHolders.add(directoryReaderHolder);
            DirectoryReader reader = directoryReaderHolder.get();
            this.mappedTypeNameByDirectoryReader.put(reader, mappedTypeName);
        }

        HolderMultiReader build() throws IOException {
            IndexReaderMetadataResolver metadataResolver = new IndexReaderMetadataResolver(this.mappedTypeNameByDirectoryReader);
            return new HolderMultiReader(this.directoryReaderHolders, metadataResolver);
        }
    }
}

