/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ThreadInterruptedException;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.IndexFailureContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class HibernateSearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final String contextDescription;
    private final ThreadProvider threadProvider;
    private final FailureHandler failureHandler;

    HibernateSearchConcurrentMergeScheduler(String indexName, String contextDescription, ThreadProvider threadProvider, FailureHandler failureHandler) {
        this.indexName = indexName;
        this.contextDescription = contextDescription;
        this.threadProvider = threadProvider;
        this.failureHandler = failureHandler;
    }

    protected void handleMergeException(Directory dir, Throwable t) {
        try {
            super.handleMergeException(dir, t);
        }
        catch (ThreadInterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            IndexFailureContext.Builder contextBuilder = IndexFailureContext.builder();
            contextBuilder.indexName(this.indexName);
            contextBuilder.throwable((Throwable)ex);
            contextBuilder.failingOperation((Object)log.indexMergeOperation());
            this.failureHandler.handle(contextBuilder.build());
        }
    }

    protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) {
        ConcurrentMergeScheduler.MergeThread thread = new ConcurrentMergeScheduler.MergeThread((ConcurrentMergeScheduler)this, writer, merge);
        thread.setDaemon(true);
        thread.setName(this.threadProvider.createThreadName("Lucene Merge Thread for " + this.contextDescription, this.mergeThreadCount++));
        return thread;
    }
}

