/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.multitenancy.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.LuceneQueryBasedDeleteEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneQueryBasedDeleteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneQueryBasedUpdateEntryWork;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class DiscriminatorMultiTenancyStrategy
implements MultiTenancyStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    @Override
    public boolean isMultiTenancySupported() {
        return true;
    }

    @Override
    public void contributeToIndexedDocument(Document document, String tenantId) {
        document.add(MetadataFields.searchableMetadataField(MetadataFields.tenantIdFieldName(), tenantId));
    }

    @Override
    public Query getFilterOrNull(String tenantId) {
        return Queries.tenantIdQuery(tenantId);
    }

    @Override
    public LuceneQueryBasedUpdateEntryWork createUpdateEntryLuceneWork(String tenantId, String id, LuceneIndexEntry indexEntry) {
        return new LuceneQueryBasedUpdateEntryWork(tenantId, id, indexEntry);
    }

    @Override
    public LuceneQueryBasedDeleteEntryWork createDeleteEntryLuceneWork(String tenantId, String id) {
        return new LuceneQueryBasedDeleteEntryWork(tenantId, id);
    }

    @Override
    public LuceneQueryBasedDeleteWork createDeleteAllEntriesLuceneWork(String tenantId) {
        return new LuceneQueryBasedDeleteWork(tenantId);
    }

    @Override
    public void checkTenantId(String tenantId, EventContext backendContext) {
        if (tenantId == null) {
            throw log.multiTenancyEnabledButNoTenantIdProvided(backendContext);
        }
    }
}

