/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.CollectorSet;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.timeout.impl.TimeoutManager;

public final class ExtractionRequirements {
    private final boolean requireScore;
    private final Set<CollectorFactory<?>> requiredCollectorForAllMatchingDocsFactories;
    private final Set<CollectorFactory<?>> requiredCollectorForTopDocsFactories;

    private ExtractionRequirements(Builder builder) {
        this.requireScore = builder.requireScore;
        this.requiredCollectorForAllMatchingDocsFactories = builder.requiredCollectorForAllMatchingDocsFactories;
        this.requiredCollectorForTopDocsFactories = builder.requiredCollectorForTopDocsFactories;
    }

    public LuceneCollectors createCollectors(IndexSearcher indexSearcher, Query luceneQuery, Sort sort, IndexReaderMetadataResolver metadataResolver, int maxDocs, TimeoutManager timeoutManager) throws IOException {
        Integer scoreSortFieldIndexForRescoring = null;
        boolean requireFieldDocRescoring = false;
        CollectorExecutionContext executionContext = new CollectorExecutionContext(metadataResolver, indexSearcher, luceneQuery, maxDocs);
        CollectorSet.Builder collectorsForAllMatchingDocsBuilder = new CollectorSet.Builder(executionContext, timeoutManager);
        if (maxDocs > 0) {
            TopScoreDocCollector topDocsCollector;
            if (sort == null) {
                topDocsCollector = TopScoreDocCollector.create((int)maxDocs, (int)Integer.MAX_VALUE);
            } else {
                if (this.requireScore) {
                    requireFieldDocRescoring = true;
                    SortField[] sortFields = sort.getSort();
                    for (int i = 0; i < sortFields.length; ++i) {
                        SortField sortField = sortFields[i];
                        if (sortField.getType() != SortField.Type.SCORE) continue;
                        scoreSortFieldIndexForRescoring = i;
                        break;
                    }
                }
                topDocsCollector = TopFieldCollector.create((Sort)sort, (int)maxDocs, (int)Integer.MAX_VALUE);
            }
            collectorsForAllMatchingDocsBuilder.add(CollectorKey.TOP_DOCS, topDocsCollector);
        }
        TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
        collectorsForAllMatchingDocsBuilder.add(CollectorKey.TOTAL_HIT_COUNT, totalHitCountCollector);
        collectorsForAllMatchingDocsBuilder.addAll(this.requiredCollectorForAllMatchingDocsFactories);
        CollectorSet collectorsForAllMatchingDocs = collectorsForAllMatchingDocsBuilder.build();
        return new LuceneCollectors(metadataResolver, indexSearcher, luceneQuery, requireFieldDocRescoring, scoreSortFieldIndexForRescoring, collectorsForAllMatchingDocs, this.requiredCollectorForTopDocsFactories, timeoutManager);
    }

    public static class Builder {
        private boolean requireScore;
        private final Set<CollectorFactory<?>> requiredCollectorForAllMatchingDocsFactories = new LinkedHashSet();
        private final Set<CollectorFactory<?>> requiredCollectorForTopDocsFactories = new LinkedHashSet();
        private boolean requireAllStoredFields = false;
        private final Set<String> requiredStoredFields = new HashSet<String>();
        private final Set<String> requiredNestedDocumentPathsForStoredFields = new HashSet<String>();

        public void requireScore() {
            this.requireScore = true;
        }

        public <C extends Collector> void requireCollectorForAllMatchingDocs(CollectorFactory<C> collectorFactory) {
            this.requiredCollectorForAllMatchingDocsFactories.add(collectorFactory);
        }

        public <C extends Collector> void requireCollectorForTopDocs(CollectorFactory<C> collectorFactory) {
            this.requiredCollectorForTopDocsFactories.add(collectorFactory);
        }

        public void requireAllStoredFields() {
            this.requireAllStoredFields = true;
            this.requiredStoredFields.clear();
        }

        public void requireStoredField(String absoluteFieldPath, String nestedDocumentPath) {
            if (!this.requireAllStoredFields) {
                this.requiredStoredFields.add(absoluteFieldPath);
            }
            if (nestedDocumentPath != null) {
                this.requiredNestedDocumentPathsForStoredFields.add(nestedDocumentPath);
            }
        }

        public ExtractionRequirements build() {
            CollectorFactory<StoredFieldsCollector> storedFieldCollectorFactory = this.createStoredFieldCollectorFactoryOrNull();
            if (storedFieldCollectorFactory != null) {
                this.requiredCollectorForTopDocsFactories.add(storedFieldCollectorFactory);
            }
            return new ExtractionRequirements(this);
        }

        private CollectorFactory<StoredFieldsCollector> createStoredFieldCollectorFactoryOrNull() {
            ReusableDocumentStoredFieldVisitor storedFieldVisitor;
            if (this.requireAllStoredFields) {
                storedFieldVisitor = new ReusableDocumentStoredFieldVisitor();
            } else if (!this.requiredStoredFields.isEmpty()) {
                storedFieldVisitor = new ReusableDocumentStoredFieldVisitor(this.requiredStoredFields);
            } else {
                return null;
            }
            return StoredFieldsCollector.factory(storedFieldVisitor, this.requiredNestedDocumentPathsForStoredFields);
        }
    }
}

