/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.ExplicitDocIdsQuery;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.CollectorSet;
import org.hibernate.search.backend.lucene.search.timeout.impl.TimeoutManager;

public class LuceneCollectors {
    private final IndexReaderMetadataResolver metadataResolver;
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final boolean requireFieldDocRescoring;
    private final Integer scoreSortFieldIndexForRescoring;
    private final CollectorSet collectorsForAllMatchingDocs;
    private final Set<CollectorFactory<?>> collectorsForTopDocsFactories;
    private CollectorSet collectorsForTopDocs;
    private final TimeoutManager timeoutManager;
    private long totalHitCount = 0L;
    private TopDocs topDocs = null;

    LuceneCollectors(IndexReaderMetadataResolver metadataResolver, IndexSearcher indexSearcher, Query luceneQuery, boolean requireFieldDocRescoring, Integer scoreSortFieldIndexForRescoring, CollectorSet collectorsForAllMatchingDocs, Set<CollectorFactory<?>> collectorsForTopDocsFactories, TimeoutManager timeoutManager) {
        this.metadataResolver = metadataResolver;
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
        this.requireFieldDocRescoring = requireFieldDocRescoring;
        this.scoreSortFieldIndexForRescoring = scoreSortFieldIndexForRescoring;
        this.collectorsForAllMatchingDocs = collectorsForAllMatchingDocs;
        this.collectorsForTopDocsFactories = collectorsForTopDocsFactories;
        this.timeoutManager = timeoutManager;
    }

    public void collect(int offset, Integer limit) throws IOException {
        if (this.timeoutManager.checkTimedOut()) {
            return;
        }
        try {
            this.indexSearcher.search(this.luceneQuery, this.collectorsForAllMatchingDocs.getComposed());
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            this.timeoutManager.forceTimedOut();
        }
        this.totalHitCount = this.collectorsForAllMatchingDocs.get(CollectorKey.TOTAL_HIT_COUNT).getTotalHits();
        TopDocsCollector topDocsCollector = this.collectorsForAllMatchingDocs.get(CollectorKey.TOP_DOCS);
        if (topDocsCollector == null) {
            return;
        }
        this.extractTopDocs(topDocsCollector, offset, limit);
        if (this.requireFieldDocRescoring) {
            this.handleRescoring(this.indexSearcher, this.luceneQuery);
        }
        if (this.collectorsForTopDocsFactories.isEmpty()) {
            return;
        }
        try {
            this.applyCollectorsToTopDocs();
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            this.timeoutManager.forceTimedOut();
        }
    }

    public CollectorSet getCollectorsForAllMatchingDocs() {
        return this.collectorsForAllMatchingDocs;
    }

    public CollectorSet getCollectorsForTopDocs() {
        return this.collectorsForTopDocs;
    }

    public long getTotalHitCount() {
        return this.totalHitCount;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    private void extractTopDocs(TopDocsCollector<?> topDocsCollector, int offset, Integer limit) {
        this.topDocs = limit == null ? topDocsCollector.topDocs(offset) : topDocsCollector.topDocs(offset, limit.intValue());
    }

    private void handleRescoring(IndexSearcher indexSearcher, Query luceneQuery) throws IOException {
        if (this.scoreSortFieldIndexForRescoring != null) {
            for (ScoreDoc scoreDoc : this.topDocs.scoreDocs) {
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                fieldDoc.score = ((Float)fieldDoc.fields[this.scoreSortFieldIndexForRescoring]).floatValue();
            }
        } else {
            TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)indexSearcher, (Query)luceneQuery);
        }
    }

    private void applyCollectorsToTopDocs() throws IOException {
        ExplicitDocIdsQuery topDocsQuery = new ExplicitDocIdsQuery(this.topDocs.scoreDocs);
        CollectorExecutionContext executionContext = new CollectorExecutionContext(this.metadataResolver, this.indexSearcher, topDocsQuery, this.topDocs.scoreDocs.length);
        CollectorSet.Builder collectorForTopDocsBuilder = new CollectorSet.Builder(executionContext, this.timeoutManager);
        collectorForTopDocsBuilder.addAll(this.collectorsForTopDocsFactories);
        this.collectorsForTopDocs = collectorForTopDocsBuilder.build();
        Collector collector = this.collectorsForTopDocs.getComposed();
        this.indexSearcher.search((Query)topDocsQuery, collector);
    }
}

