/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.search.timeout.impl.TimeoutManager;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;

public final class LuceneSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final LuceneScopeModel scopeModel;

    public LuceneSearchContext(BackendMappingContext mappingContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, TimingSource timingSource, LuceneScopeModel scopeModel) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.scopeModel = scopeModel;
    }

    public ToDocumentIdentifierValueConvertContext getToDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext getToDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }

    public Set<String> getIndexNames() {
        return this.scopeModel.getIndexNames();
    }

    public Set<? extends ReadIndexManagerContext> getIndexManagerContexts() {
        return this.scopeModel.getIndexManagerContexts();
    }

    public Query getFilterOrNull(String tenantId) {
        return this.multiTenancyStrategy.getFilterOrNull(tenantId);
    }

    public TimeoutManager createTimeoutManager(Query definitiveLuceneQuery, Long timeout, TimeUnit timeUnit, boolean exceptionOnTimeout) {
        if (timeout != null && timeUnit != null) {
            if (exceptionOnTimeout) {
                return TimeoutManager.hardTimeout(this.timingSource, definitiveLuceneQuery, timeout, timeUnit);
            }
            return TimeoutManager.softTimeout(this.timingSource, definitiveLuceneQuery, timeout, timeUnit);
        }
        return TimeoutManager.noTimeout(this.timingSource, definitiveLuceneQuery);
    }
}

