/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopedIndexFieldComponent;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopedIndexRootComponent;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneBooleanPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchAllPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchIdPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNestedPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateCollector;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSimpleQueryStringPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneUserProvidedLuceneQueryPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneSearchPredicateBuilderFactoryImpl
implements LuceneSearchPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final PredicateBuilderFactoryRetrievalStrategy PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new PredicateBuilderFactoryRetrievalStrategy();
    private final LuceneSearchContext searchContext;
    private final LuceneScopeModel scopeModel;

    public LuceneSearchPredicateBuilderFactoryImpl(LuceneSearchContext searchContext, LuceneScopeModel scopeModel) {
        this.searchContext = searchContext;
        this.scopeModel = scopeModel;
    }

    public SearchPredicate toSearchPredicate(LuceneSearchPredicateBuilder builder) {
        return new LuceneSearchPredicate(this.scopeModel.getIndexNames(), builder);
    }

    public LuceneSearchPredicateBuilder toImplementation(SearchPredicate predicate) {
        if (!(predicate instanceof LuceneSearchPredicate)) {
            throw log.cannotMixLuceneSearchQueryWithOtherPredicates(predicate);
        }
        LuceneSearchPredicate casted = (LuceneSearchPredicate)predicate;
        if (!this.scopeModel.getIndexNames().equals(casted.getIndexNames())) {
            throw log.predicateDefinedOnDifferentIndexes(predicate, casted.getIndexNames(), this.scopeModel.getIndexNames());
        }
        return casted;
    }

    public void contribute(LuceneSearchPredicateCollector collector, LuceneSearchPredicateBuilder builder) {
        collector.collectPredicate(builder.build(LuceneSearchPredicateContext.root()));
    }

    public MatchAllPredicateBuilder<LuceneSearchPredicateBuilder> matchAll() {
        return new LuceneMatchAllPredicateBuilder();
    }

    public MatchIdPredicateBuilder<LuceneSearchPredicateBuilder> id() {
        LuceneScopedIndexRootComponent<ToDocumentIdentifierValueConverter<?>> component = this.scopeModel.getIdDslConverter();
        return new LuceneMatchIdPredicateBuilder(this.searchContext, component.getIdConverterCompatibilityChecker(), component.getComponent());
    }

    public BooleanPredicateBuilder<LuceneSearchPredicateBuilder> bool() {
        return new LuceneBooleanPredicateBuilder();
    }

    public MatchPredicateBuilder<LuceneSearchPredicateBuilder> match(String absoluteFieldPath) {
        LuceneScopedIndexFieldComponent<LuceneFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createMatchPredicateBuilder(this.searchContext, absoluteFieldPath, fieldComponent.getConverterCompatibilityChecker(), fieldComponent.getAnalyzerCompatibilityChecker());
    }

    public RangePredicateBuilder<LuceneSearchPredicateBuilder> range(String absoluteFieldPath) {
        LuceneScopedIndexFieldComponent<LuceneFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createRangePredicateBuilder(this.searchContext, absoluteFieldPath, fieldComponent.getConverterCompatibilityChecker());
    }

    public PhrasePredicateBuilder<LuceneSearchPredicateBuilder> phrase(String absoluteFieldPath) {
        LuceneScopedIndexFieldComponent<LuceneFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        return fieldComponent.getComponent().createPhrasePredicateBuilder(this.searchContext, absoluteFieldPath, fieldComponent.getAnalyzerCompatibilityChecker());
    }

    public WildcardPredicateBuilder<LuceneSearchPredicateBuilder> wildcard(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createWildcardPredicateBuilder(absoluteFieldPath);
    }

    public SimpleQueryStringPredicateBuilder<LuceneSearchPredicateBuilder> simpleQueryString() {
        return new LuceneSimpleQueryStringPredicateBuilder(this.searchContext, this.scopeModel);
    }

    public ExistsPredicateBuilder<LuceneSearchPredicateBuilder> exists(String absoluteFieldPath) {
        LuceneObjectPredicateBuilderFactory objectPredicateBuilderFactory = this.scopeModel.getObjectPredicateBuilderFactory(absoluteFieldPath);
        if (objectPredicateBuilderFactory != null) {
            return objectPredicateBuilderFactory.createExistsPredicateBuilder();
        }
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createExistsPredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinCirclePredicateBuilder<LuceneSearchPredicateBuilder> spatialWithinCircle(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createSpatialWithinCirclePredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinPolygonPredicateBuilder<LuceneSearchPredicateBuilder> spatialWithinPolygon(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createSpatialWithinPolygonPredicateBuilder(absoluteFieldPath);
    }

    public SpatialWithinBoundingBoxPredicateBuilder<LuceneSearchPredicateBuilder> spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath);
    }

    public NestedPredicateBuilder<LuceneSearchPredicateBuilder> nested(String absoluteFieldPath) {
        this.scopeModel.checkNestedField(absoluteFieldPath);
        return new LuceneNestedPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public LuceneSearchPredicateBuilder fromLuceneQuery(Query query) {
        return new LuceneUserProvidedLuceneQueryPredicateBuilder(query);
    }

    private static class PredicateBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<LuceneFieldPredicateBuilderFactory> {
        private PredicateBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public LuceneFieldPredicateBuilderFactory extractComponent(LuceneIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getPredicateBuilderFactory();
        }

        @Override
        public boolean hasCompatibleCodec(LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2) {
            return component1.hasCompatibleCodec(component2);
        }

        @Override
        public boolean hasCompatibleConverter(LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2) {
            return component1.hasCompatibleConverter(component2);
        }

        @Override
        public boolean hasCompatibleAnalyzer(LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2) {
            return component1.hasCompatibleAnalyzer(component2);
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, LuceneFieldPredicateBuilderFactory component1, LuceneFieldPredicateBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForPredicate(absoluteFieldPath, component1, component2, context);
        }
    }
}

