/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.dsl.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScope;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryHitTypeStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryOptionsStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryPredicateStep;
import org.hibernate.search.backend.lucene.search.query.dsl.impl.LuceneSearchQueryOptionsStepImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQueryHitTypeStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class LuceneSearchQueryHitTypeStepImpl<R, E, LOS>
extends AbstractSearchQueryHitTypeStep<LuceneSearchQueryOptionsStep<E, LOS>, R, E, LOS, LuceneSearchProjectionFactory<R, E>, LuceneSearchPredicateFactory, LuceneSearchQueryElementCollector>
implements LuceneSearchQueryHitTypeStep<R, E, LOS> {
    private final LuceneIndexScope indexScope;
    private final BackendSessionContext sessionContext;
    private final LoadingContextBuilder<R, E, LOS> loadingContextBuilder;

    public LuceneSearchQueryHitTypeStepImpl(LuceneIndexScope indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public LuceneSearchQueryPredicateStep<E, LOS> asEntity() {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asEntity(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryPredicateStep<R, LOS> asEntityReference() {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asReference(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public <P> LuceneSearchQueryPredicateStep<P, LOS> asProjection(Function<? super LuceneSearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        LuceneSearchProjectionFactory factoryContext = (LuceneSearchProjectionFactory)this.createDefaultProjectionFactory().extension(LuceneExtension.get());
        SearchProjection projection = projectionContributor.apply(factoryContext).toProjection();
        return this.asProjection(projection);
    }

    @Override
    public <P> LuceneSearchQueryPredicateStep<P, LOS> asProjection(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asProjection(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryPredicateStep<List<?>, LOS> asProjections(SearchProjection<?> ... projections) {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().asProjections(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection[])projections);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    public LuceneSearchQueryOptionsStep<E, LOS> predicate(SearchPredicate predicate) {
        return (LuceneSearchQueryOptionsStep)this.asEntity().predicate(predicate);
    }

    public LuceneSearchQueryOptionsStep<E, LOS> predicate(Function<? super LuceneSearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return (LuceneSearchQueryOptionsStep)this.asEntity().predicate(predicateContributor);
    }

    protected LuceneIndexScope getIndexScope() {
        return this.indexScope;
    }

    protected BackendSessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected LoadingContextBuilder<R, E, LOS> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }

    private <H> LuceneSearchQueryPredicateStep<H, LOS> createSearchQueryContext(LuceneSearchQueryBuilder<H> builder) {
        return new LuceneSearchQueryOptionsStepImpl<H, LOS>(this.indexScope, builder, this.loadingContextBuilder);
    }
}

