/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultImpl;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;

public class LuceneLoadableSearchResult<H> {
    private final LuceneSearchQueryExtractContext extractContext;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final long hitCount;
    private List<Object> extractedData;
    private final Map<AggregationKey<?>, ?> extractedAggregations;
    private Duration took;
    private Boolean timedOut;

    LuceneLoadableSearchResult(LuceneSearchQueryExtractContext extractContext, LuceneSearchProjection<?, H> rootProjection, long hitCount, List<Object> extractedData, Map<AggregationKey<?>, ?> extractedAggregations, Duration took, boolean timedOut) {
        this.extractContext = extractContext;
        this.rootProjection = rootProjection;
        this.hitCount = hitCount;
        this.extractedData = extractedData;
        this.extractedAggregations = extractedAggregations;
        this.took = took;
        this.timedOut = timedOut;
    }

    LuceneSearchResult<H> loadBlocking() {
        int readIndex;
        SearchProjectionTransformContext transformContext = this.extractContext.createProjectionTransformContext();
        LoadingResult loadingResult = this.extractContext.getProjectionHitMapper().loadBlocking();
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.extractedData.size(); ++readIndex) {
            transformContext.reset();
            H transformed = LuceneSearchProjection.transformUnsafe(this.rootProjection, loadingResult, this.extractedData.get(readIndex), transformContext);
            if (transformContext.hasFailedLoad()) continue;
            this.extractedData.set(writeIndex, transformed);
            ++writeIndex;
        }
        if (writeIndex < readIndex) {
            this.extractedData.subList(writeIndex, readIndex).clear();
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedData);
        this.extractedData = null;
        return new LuceneSearchResultImpl<Object>(this.hitCount, loadedHits, this.extractedAggregations, this.took, this.timedOut);
    }
}

