/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.FromDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class LuceneSearchQueryExtractContext {
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final FromDocumentFieldValueConvertContext convertContext;
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final LuceneCollectors luceneCollectors;

    LuceneSearchQueryExtractContext(BackendSessionContext sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, IndexSearcher indexSearcher, Query luceneQuery, LuceneCollectors luceneCollectors) {
        this.projectionHitMapper = projectionHitMapper;
        this.convertContext = new FromDocumentFieldValueConvertContextImpl(sessionContext);
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
        this.luceneCollectors = luceneCollectors;
    }

    ProjectionHitMapper<?, ?> getProjectionHitMapper() {
        return this.projectionHitMapper;
    }

    TopDocs getTopDocs() {
        return this.luceneCollectors.getTopDocs();
    }

    SearchProjectionExtractContext createProjectionExtractContext() {
        return new SearchProjectionExtractContext(this.indexSearcher, this.luceneQuery, this.luceneCollectors.getCollectorsForTopDocs());
    }

    SearchProjectionTransformContext createProjectionTransformContext() {
        return new SearchProjectionTransformContext(this.convertContext);
    }

    AggregationExtractContext createAggregationExtractContext() {
        return new AggregationExtractContext(this.indexSearcher.getIndexReader(), this.convertContext, this.luceneCollectors.getCollectorsForAllMatchingDocs());
    }
}

