/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TimeoutCountCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.search.timeout.impl.TimeoutManager;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.logging.impl.DefaultLogCategories;
import org.hibernate.search.util.common.logging.impl.LogCategory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneSearcherImpl<H>
implements LuceneSearcher<LuceneLoadableSearchResult<H>> {
    private static final Log queryLog = (Log)LoggerFactory.make(Log.class, (LogCategory)DefaultLogCategories.QUERY);
    private final LuceneSearchQueryRequestContext requestContext;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;
    private final ExtractionRequirements extractionRequirements;
    private TimeoutManager timeoutManager;

    LuceneSearcherImpl(LuceneSearchQueryRequestContext requestContext, LuceneSearchProjection<?, H> rootProjection, Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations, ExtractionRequirements extractionRequirements, TimeoutManager timeoutManager) {
        this.requestContext = requestContext;
        this.rootProjection = rootProjection;
        this.aggregations = aggregations;
        this.extractionRequirements = extractionRequirements;
        this.timeoutManager = timeoutManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("luceneQuery=").append(this.requestContext.getLuceneQuery()).append(", luceneSort=").append(this.requestContext.getLuceneSort()).append("]");
        return sb.toString();
    }

    @Override
    public LuceneLoadableSearchResult<H> search(IndexSearcher indexSearcher, IndexReaderMetadataResolver metadataResolver, int offset, Integer limit) throws IOException {
        queryLog.executingLuceneQuery(this.requestContext.getLuceneQuery());
        LuceneCollectors luceneCollectors = this.buildCollectors(indexSearcher, metadataResolver, offset, limit);
        luceneCollectors.collect(offset, limit);
        LuceneSearchQueryExtractContext extractContext = this.requestContext.createExtractContext(indexSearcher, luceneCollectors);
        List<Object> extractedData = this.extractHits(extractContext);
        Map extractedAggregations = this.aggregations.isEmpty() ? Collections.emptyMap() : this.extractAggregations(extractContext);
        return new LuceneLoadableSearchResult<H>(extractContext, this.rootProjection, luceneCollectors.getTotalHitCount(), extractedData, extractedAggregations, this.timeoutManager.getTookTime(), this.timeoutManager.isTimedOut());
    }

    @Override
    public int count(IndexSearcher indexSearcher) throws IOException {
        queryLog.executingLuceneQuery(this.requestContext.getLuceneQuery());
        if (this.timeoutManager.hasHardTimeout()) {
            return (Integer)indexSearcher.search(this.requestContext.getLuceneQuery(), (CollectorManager)new TimeoutCountCollectorManager(this.timeoutManager));
        }
        return indexSearcher.count(this.requestContext.getLuceneQuery());
    }

    @Override
    public Explanation explain(IndexSearcher indexSearcher, int luceneDocId) throws IOException {
        return indexSearcher.explain(this.requestContext.getLuceneQuery(), luceneDocId);
    }

    @Override
    public Query getLuceneQueryForExceptions() {
        return this.requestContext.getLuceneQuery();
    }

    @Override
    public void setTimeoutManager(TimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
    }

    private LuceneCollectors buildCollectors(IndexSearcher indexSearcher, IndexReaderMetadataResolver metadataResolver, int offset, Integer limit) throws IOException {
        int maxDocs = this.getMaxDocs(indexSearcher.getIndexReader(), offset, limit);
        return this.extractionRequirements.createCollectors(indexSearcher, this.requestContext.getLuceneQuery(), this.requestContext.getLuceneSort(), metadataResolver, maxDocs, this.timeoutManager);
    }

    private int getMaxDocs(IndexReader reader, int offset, Integer limit) {
        if (limit == null) {
            return reader.maxDoc();
        }
        if (limit.equals(0)) {
            return 0;
        }
        return Math.min(offset + limit, reader.maxDoc());
    }

    private List<Object> extractHits(LuceneSearchQueryExtractContext extractContext) {
        ProjectionHitMapper<?, ?> projectionHitMapper = extractContext.getProjectionHitMapper();
        TopDocs topDocs = extractContext.getTopDocs();
        if (topDocs == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> extractedData = new ArrayList<Object>(topDocs.scoreDocs.length);
        SearchProjectionExtractContext projectionExtractContext = extractContext.createProjectionExtractContext();
        StoredFieldsCollector storedFieldsCollector = projectionExtractContext.getCollector(StoredFieldsCollector.KEY);
        for (int i = 0; !(i >= topDocs.scoreDocs.length || i % 16 == 0 && this.timeoutManager.checkTimedOut()); ++i) {
            ScoreDoc hit = topDocs.scoreDocs[i];
            Document document = storedFieldsCollector == null ? null : storedFieldsCollector.getDocument(hit.doc);
            LuceneResult luceneResult = new LuceneResult(document, hit.doc, hit.score);
            extractedData.add(this.rootProjection.extract(projectionHitMapper, luceneResult, projectionExtractContext));
        }
        return extractedData;
    }

    private Map<AggregationKey<?>, ?> extractAggregations(LuceneSearchQueryExtractContext extractContext) throws IOException {
        AggregationExtractContext aggregationExtractContext = extractContext.createAggregationExtractContext();
        LinkedHashMap extractedMap = new LinkedHashMap();
        for (Map.Entry<AggregationKey<?>, LuceneSearchAggregation<?>> entry : this.aggregations.entrySet()) {
            if (this.timeoutManager.checkTimedOut()) break;
            AggregationKey<?> key = entry.getKey();
            LuceneSearchAggregation<?> aggregation = entry.getValue();
            Object extracted = aggregation.extract(aggregationExtractContext);
            extractedMap.put(key, extracted);
        }
        return extractedMap;
    }
}

