/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneStandardFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneNumericRangeAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneNumericTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;

public class LuceneNumericFieldAggregationBuilderFactory<F>
extends AbstractLuceneStandardFieldAggregationBuilderFactory<F>
implements LuceneFieldAggregationBuilderFactory {
    private final AbstractLuceneNumericFieldCodec<F, ?> codec;

    public LuceneNumericFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends F> toFieldValueConverter, DslConverter<? super F, ? extends F> rawToFieldValueConverter, ProjectionConverter<? super F, ?> fromFieldValueConverter, ProjectionConverter<? super F, F> rawFromFieldValueConverter, AbstractLuceneNumericFieldCodec<F, ?> codec) {
        super(aggregable, toFieldValueConverter, rawToFieldValueConverter, fromFieldValueConverter, rawFromFieldValueConverter);
        this.codec = codec;
    }

    @Override
    public <K> TermsAggregationBuilder<K> createTermsAggregationBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        this.checkAggregable(absoluteFieldPath);
        ProjectionConverter fromFieldValueConverter = this.getFromFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new LuceneNumericTermsAggregation.Builder(searchContext, absoluteFieldPath, fromFieldValueConverter, this.getCodec());
    }

    @Override
    public <K> RangeAggregationBuilder<K> createRangeAggregationBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        this.checkAggregable(absoluteFieldPath);
        DslConverter toFieldValueConverter = this.getToFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new LuceneNumericRangeAggregation.Builder(searchContext, absoluteFieldPath, toFieldValueConverter, this.codec);
    }

    protected AbstractLuceneNumericFieldCodec<F, ?> getCodec() {
        return this.codec;
    }
}

