/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LongValueFacetCounts;
import org.apache.lucene.facet.range.DoubleRangeFacetCounts;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DocValuesJoin;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.FacetCountsUtils;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.util.common.data.Range;

public class LuceneFloatDomain
implements LuceneNumericDomain<Float> {
    private static final LuceneNumericDomain<Float> INSTANCE = new LuceneFloatDomain();

    public static LuceneNumericDomain<Float> get() {
        return INSTANCE;
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(Float.MIN_VALUE);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(Float.MAX_VALUE);
    }

    @Override
    public Float getPreviousValue(Float value) {
        return Float.valueOf(Math.nextDown(value.floatValue()));
    }

    @Override
    public Float getNextValue(Float value) {
        return Float.valueOf(Math.nextUp(value.floatValue()));
    }

    @Override
    public Query createExactQuery(String absoluteFieldPath, Float value) {
        return FloatPoint.newExactQuery((String)absoluteFieldPath, (float)value.floatValue());
    }

    @Override
    public Query createRangeQuery(String absoluteFieldPath, Float lowerLimit, Float upperLimit) {
        return FloatPoint.newRangeQuery((String)absoluteFieldPath, (float)lowerLimit.floatValue(), (float)upperLimit.floatValue());
    }

    @Override
    public Float fromDocValue(Long longValue) {
        return Float.valueOf(Float.intBitsToFloat(longValue.intValue()));
    }

    @Override
    public LongValueFacetCounts createTermsFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector) throws IOException {
        return new LongValueFacetCounts(absoluteFieldPath, LongValuesSource.fromIntField((String)absoluteFieldPath), facetsCollector);
    }

    @Override
    public Facets createRangeFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector, Collection<? extends Range<? extends Float>> ranges) throws IOException {
        return new DoubleRangeFacetCounts(absoluteFieldPath, DoubleValuesSource.fromFloatField((String)absoluteFieldPath), facetsCollector, FacetCountsUtils.createDoubleRanges(ranges));
    }

    @Override
    public IndexableField createIndexField(String absoluteFieldPath, Float numericValue) {
        return new FloatPoint(absoluteFieldPath, new float[]{numericValue.floatValue()});
    }

    @Override
    public IndexableField createDocValuesField(String absoluteFieldPath, Float numericValue) {
        return new FloatDocValuesField(absoluteFieldPath, numericValue.floatValue());
    }

    @Override
    public FieldComparator.NumericComparator<Float> createFieldComparator(String fieldname, int numHits, Float missingValue, NestedDocsProvider nestedDocsProvider) {
        return new FloatFieldComparator(numHits, fieldname, missingValue, nestedDocsProvider);
    }

    public static class FloatFieldComparator
    extends FieldComparator.FloatComparator {
        private NestedDocsProvider nestedDocsProvider;

        public FloatFieldComparator(int numHits, String field, Float missingValue, NestedDocsProvider nestedDocsProvider) {
            super(numHits, field, missingValue);
            this.nestedDocsProvider = nestedDocsProvider;
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return DocValuesJoin.getJoinedAsSingleValuedNumericFloat(context, field, this.nestedDocsProvider, ((Float)this.missingValue).floatValue());
        }
    }
}

