/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.FuzzyQueryBuilder;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneStandardMatchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneTextMatchPredicateBuilder<F>
extends AbstractLuceneStandardMatchPredicateBuilder<F, String, LuceneTextFieldCodec<F>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneCompatibilityChecker analyzerChecker;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private Integer maxEditDistance;
    private Integer prefixLength;
    private Analyzer analyzer;
    private boolean analyzerOverridden = false;

    LuceneTextMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, LuceneTextFieldCodec<F> codec, Analyzer analyzerOrNormalizer, LuceneCompatibilityChecker analyzerChecker) {
        super(searchContext, absoluteFieldPath, converter, rawConverter, converterChecker, codec);
        this.analyzer = analyzerOrNormalizer;
        this.analyzerChecker = analyzerChecker;
        this.analysisDefinitionRegistry = searchContext.getAnalysisDefinitionRegistry();
    }

    @Override
    public void fuzzy(int maxEditDistance, int exactPrefixLength) {
        this.maxEditDistance = maxEditDistance;
        this.prefixLength = exactPrefixLength;
    }

    @Override
    public void analyzer(String analyzerName) {
        this.analyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
        if (this.analyzer == null) {
            throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        this.analyzerOverridden = true;
    }

    @Override
    public void skipAnalysis() {
        this.analyzer = AnalyzerConstants.KEYWORD_ANALYZER;
        this.analyzerOverridden = true;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (!this.analyzerOverridden) {
            this.analyzerChecker.failIfNotCompatible();
        }
        if (this.analyzer != null) {
            QueryBuilder effectiveQueryBuilder = this.maxEditDistance != null ? new FuzzyQueryBuilder(this.analyzer, this.maxEditDistance, this.prefixLength) : new QueryBuilder(this.analyzer);
            Query analyzed = effectiveQueryBuilder.createBooleanQuery(this.absoluteFieldPath, (String)this.value);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the value to match");
            }
            return analyzed;
        }
        Term term = new Term(this.absoluteFieldPath, ((LuceneTextFieldCodec)this.codec).normalize(this.absoluteFieldPath, (String)this.value));
        if (this.maxEditDistance != null) {
            return new FuzzyQuery(term, this.maxEditDistance.intValue(), this.prefixLength.intValue());
        }
        return new TermQuery(term);
    }
}

