/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DocValuesJoin;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;

public class LuceneGeoPointDistanceComparatorSource
extends LuceneFieldComparatorSource {
    private static final double MISSING_VALUE_IMPLICIT_DISTANCE_VALUE = Double.POSITIVE_INFINITY;
    private final double latitude;
    private final double longitude;

    public LuceneGeoPointDistanceComparatorSource(String nestedDocumentPath, double latitude, double longitude) {
        super(nestedDocumentPath);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        return new FieldComparator.DoubleComparator(numHits, fieldname, Double.POSITIVE_INFINITY){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                return DocValuesJoin.getJoinedAsSingleValuedDistance(context, field, LuceneGeoPointDistanceComparatorSource.this.nestedDocsProvider, LuceneGeoPointDistanceComparatorSource.this.latitude, LuceneGeoPointDistanceComparatorSource.this.longitude, Double.POSITIVE_INFINITY).getRawDoubleValues();
            }
        };
    }
}

