/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneGeoPointDistanceComparatorSource;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneGeoPointDistanceSortBuilder
extends AbstractLuceneSearchSortBuilder
implements DistanceSortBuilder<LuceneSearchSortBuilder> {
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final GeoPoint location;

    LuceneGeoPointDistanceSortBuilder(String absoluteFieldPath, String nestedDocumentPath, GeoPoint location) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedDocumentPath = nestedDocumentPath;
        this.location = location;
    }

    @Override
    public void buildAndContribute(LuceneSearchSortCollector collector) {
        LuceneGeoPointDistanceComparatorSource fieldComparatorSource = new LuceneGeoPointDistanceComparatorSource(this.nestedDocumentPath, this.location.getLatitude(), this.location.getLongitude());
        SortField sortField = new SortField(this.absoluteFieldPath, (FieldComparatorSource)fieldComparatorSource, this.order == SortOrder.DESC);
        collector.collectSortField(sortField, this.nestedDocumentPath == null ? null : fieldComparatorSource);
    }
}

