/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class LuceneIndexIndexer
implements IndexIndexer<LuceneRootDocumentBuilder> {
    private final LuceneWorkFactory factory;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;
    private final DocumentCommitStrategy commitStrategy;

    public LuceneIndexIndexer(LuceneWorkFactory factory, LuceneIndexEntryFactory indexEntryFactory, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy) {
        this.factory = factory;
        this.indexEntryFactory = indexEntryFactory;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.getTenantIdentifier();
        this.commitStrategy = commitStrategy;
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, documentContributor);
        LuceneWriteWorkOrchestrator orchestrator = this.indexManagerContext.getWriteOrchestrator(id, routingKey);
        return orchestrator.submit(this.factory.add(this.tenantId, id, indexEntry), this.commitStrategy, DocumentRefreshStrategy.NONE);
    }
}

