/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkSet;
import org.hibernate.search.backend.lucene.search.impl.LuceneDocumentReference;
import org.hibernate.search.backend.lucene.work.impl.LuceneSingleDocumentWriteWork;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;

class LuceneIndexingPlanWriteWorkSet
implements LuceneWriteWorkSet {
    private final String indexName;
    private final List<LuceneSingleDocumentWriteWork<?>> works;
    private final CompletableFuture<IndexIndexingPlanExecutionReport> indexingPlanFuture;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;

    LuceneIndexingPlanWriteWorkSet(String indexName, List<LuceneSingleDocumentWriteWork<?>> works, CompletableFuture<IndexIndexingPlanExecutionReport> indexingPlanFuture, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.indexName = indexName;
        this.works = new ArrayList(works);
        this.indexingPlanFuture = indexingPlanFuture;
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    public void submitTo(LuceneWriteWorkProcessor processor) {
        IndexIndexingPlanExecutionReport.Builder reportBuilder = IndexIndexingPlanExecutionReport.builder();
        processor.beforeWorkSet(this.commitStrategy, this.refreshStrategy);
        RuntimeException throwable = null;
        for (LuceneSingleDocumentWriteWork<?> work : this.works) {
            try {
                processor.submit(work);
            }
            catch (RuntimeException e) {
                reportBuilder.throwable((Throwable)e);
                throwable = e;
                break;
            }
        }
        if (throwable == null) {
            try {
                processor.afterSuccessfulWorkSet();
            }
            catch (RuntimeException e) {
                reportBuilder.throwable((Throwable)e);
                throwable = e;
            }
        }
        if (throwable == null) {
            this.indexingPlanFuture.complete(reportBuilder.build());
        } else {
            for (LuceneSingleDocumentWriteWork<?> work : this.works) {
                reportBuilder.failingDocument((DocumentReference)new LuceneDocumentReference(this.indexName, work.getDocumentId()));
            }
            this.indexingPlanFuture.complete(reportBuilder.build());
        }
    }

    public void markAsFailed(Throwable t) {
        this.indexingPlanFuture.completeExceptionally(t);
    }
}

