/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSingleDocumentWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneDeleteEntryWork
extends AbstractLuceneWriteWork<Long>
implements LuceneSingleDocumentWriteWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;
    private final String id;

    AbstractLuceneDeleteEntryWork(String tenantId, String id) {
        super("deleteEntry");
        this.tenantId = tenantId;
        this.id = id;
    }

    @Override
    public Long execute(LuceneWriteWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexWriterDelegator();
            return this.doDeleteDocuments(indexWriterDelegator, this.tenantId, this.id);
        }
        catch (IOException e) {
            throw log.unableToDeleteEntryFromIndex(this.tenantId, this.id, context.getEventContext(), e);
        }
    }

    protected abstract long doDeleteDocuments(IndexWriterDelegator var1, String var2, String var3) throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", id=").append(this.id).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentId() {
        return this.id;
    }
}

