/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneCountWork
implements LuceneReadWork<Integer> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearcher<?> searcher;

    LuceneCountWork(LuceneSearcher<?> searcher) {
        this.searcher = searcher;
    }

    @Override
    public Integer execute(LuceneReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher(context.getIndexReader());
            return this.searcher.count(indexSearcher);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append("]");
        return sb.toString();
    }
}

