/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchWork<R>
implements LuceneReadWork<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearcher<R> searcher;
    private final int offset;
    private final Integer limit;

    LuceneSearchWork(LuceneSearcher<R> searcher, Integer offset, Integer limit) {
        this.offset = offset == null ? 0 : offset;
        this.limit = limit;
        this.searcher = searcher;
    }

    @Override
    public R execute(LuceneReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher(context.getIndexReader());
            return this.searcher.search(indexSearcher, context.getIndexReaderMetadataResolver(), this.offset, this.limit);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append(", offset=").append(this.offset).append(", limit=").append(this.limit).append("]");
        return sb.toString();
    }
}

