/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneNonFlattenedDocumentBuilder
extends AbstractLuceneDocumentBuilder
implements LuceneDocumentBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final Document document = new Document();
    private final Map<String, EncounteredFieldStatus> fieldStatus = new HashMap<String, EncounteredFieldStatus>();

    AbstractLuceneNonFlattenedDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        super(schemaNode);
    }

    @Override
    public void addField(IndexableField field) {
        this.document.add(field);
    }

    @Override
    public void addFieldName(String absoluteFieldPath) {
        this.fieldStatus.put(absoluteFieldPath, EncounteredFieldStatus.ENCOUNTERED_AND_NAME_INDEXED);
    }

    @Override
    void checkNoValueYetForSingleValued(String absoluteFieldPath) {
        EncounteredFieldStatus previousValue = this.fieldStatus.putIfAbsent(absoluteFieldPath, EncounteredFieldStatus.ENCOUNTERED);
        if (previousValue != null) {
            throw log.multipleValuesForSingleValuedField(absoluteFieldPath);
        }
    }

    @Override
    void contribute(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String routingKey, String rootId, List<Document> nestedDocuments) {
        for (Map.Entry<String, EncounteredFieldStatus> entry : this.fieldStatus.entrySet()) {
            EncounteredFieldStatus status = entry.getValue();
            if (!EncounteredFieldStatus.ENCOUNTERED_AND_NAME_INDEXED.equals((Object)status)) continue;
            String fieldName = entry.getKey();
            this.document.add(MetadataFields.searchableMetadataField(MetadataFields.fieldNamesFieldName(), fieldName));
        }
        if (routingKey != null) {
            this.document.add(MetadataFields.searchableMetadataField(MetadataFields.routingKeyFieldName(), routingKey));
        }
        multiTenancyStrategy.contributeToIndexedDocument(this.document, tenantId);
        super.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
    }

    private static enum EncounteredFieldStatus {
        ENCOUNTERED,
        ENCOUNTERED_AND_NAME_INDEXED;

    }
}

