/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import org.apache.lucene.facet.FacetsConfig;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;

public class LuceneIndexEntryFactory {
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final String indexName;
    private final FacetsConfig facetsConfig;

    public LuceneIndexEntryFactory(MultiTenancyStrategy multiTenancyStrategy, String indexName, FacetsConfig facetsConfig) {
        this.indexName = indexName;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.facetsConfig = facetsConfig;
    }

    public LuceneIndexEntry create(String tenantId, String id, String routingKey, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder(this.multiTenancyStrategy, this.indexName, this.facetsConfig);
        documentContributor.contribute((Object)builder);
        return builder.build(tenantId, id, routingKey);
    }
}

