/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.GeoPointDistanceDocValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.NumericDoubleValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.SortedNumericDoubleValues;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.util.common.impl.Contracts;

public class DocValuesJoin {
    private DocValuesJoin() {
    }

    public static SortedDocValues getJoinedAsSingleValuedSorted(LeafReaderContext context, String field, NestedDocsProvider nestedDocsProvider) throws IOException {
        SortedDocValues sortedDocValues = DocValues.getSorted((LeafReader)context.reader(), (String)field);
        if (nestedDocsProvider == null) {
            return sortedDocValues;
        }
        BitSet parentDocs = nestedDocsProvider.parentDocs(context);
        DocIdSetIterator childDocs = nestedDocsProvider.childDocs(context);
        if (parentDocs == null || childDocs == null) {
            return sortedDocValues;
        }
        return DocValuesJoin.joinAsSingleValued(sortedDocValues, parentDocs, childDocs);
    }

    public static NumericDocValues getJoinedAsSingleValuedNumeric(LeafReaderContext context, String field, NestedDocsProvider nestedDocsProvider, long missingValue) throws IOException {
        NumericDocValues numericDocValues = DocValues.getNumeric((LeafReader)context.reader(), (String)field);
        if (nestedDocsProvider == null) {
            return numericDocValues;
        }
        SortedNumericDocValues sortedNumericDocValues = DocValues.singleton((NumericDocValues)numericDocValues);
        BitSet parentDocs = nestedDocsProvider.parentDocs(context);
        DocIdSetIterator childDocs = nestedDocsProvider.childDocs(context);
        if (parentDocs == null || childDocs == null) {
            return numericDocValues;
        }
        return DocValuesJoin.joinAsSingleValued(sortedNumericDocValues, missingValue, parentDocs, childDocs);
    }

    public static NumericDocValues getJoinedAsSingleValuedNumericDouble(LeafReaderContext context, String field, NestedDocsProvider nestedDocsProvider, double missingValue) throws IOException {
        NumericDocValues numericDocValues = DocValues.getNumeric((LeafReader)context.reader(), (String)field);
        if (nestedDocsProvider == null) {
            return numericDocValues;
        }
        SortedNumericDoubleValues sortedNumericDoubleValues = SortedNumericDoubleValues.createDouble(numericDocValues);
        BitSet parentDocs = nestedDocsProvider.parentDocs(context);
        DocIdSetIterator childDocs = nestedDocsProvider.childDocs(context);
        if (parentDocs == null || childDocs == null) {
            return numericDocValues;
        }
        return DocValuesJoin.joinAsSingleValued(sortedNumericDoubleValues, missingValue, parentDocs, childDocs).getRawDoubleValues();
    }

    public static NumericDocValues getJoinedAsSingleValuedNumericFloat(LeafReaderContext context, String field, NestedDocsProvider nestedDocsProvider, float missingValue) throws IOException {
        NumericDocValues numericDocValues = DocValues.getNumeric((LeafReader)context.reader(), (String)field);
        if (nestedDocsProvider == null) {
            return numericDocValues;
        }
        SortedNumericDoubleValues sortedNumericDoubleValues = SortedNumericDoubleValues.createFloat(numericDocValues);
        BitSet parentDocs = nestedDocsProvider.parentDocs(context);
        DocIdSetIterator childDocs = nestedDocsProvider.childDocs(context);
        if (parentDocs == null || childDocs == null) {
            return numericDocValues;
        }
        return DocValuesJoin.joinAsSingleValued(sortedNumericDoubleValues, missingValue, parentDocs, childDocs).getRawFloatValues();
    }

    public static NumericDoubleValues getJoinedAsSingleValuedDistance(LeafReaderContext context, String field, NestedDocsProvider nestedDocsProvider, double centerLatitude, double centerLongitude, double missingValue) throws IOException {
        SortedNumericDocValues sortedNumericDocValues = context.reader().getSortedNumericDocValues(field);
        GeoPointDistanceDocValues geoPointDistanceDocValues = new GeoPointDistanceDocValues(sortedNumericDocValues, centerLatitude, centerLongitude);
        if (nestedDocsProvider == null) {
            return geoPointDistanceDocValues;
        }
        BitSet parentDocs = nestedDocsProvider.parentDocs(context);
        DocIdSetIterator childDocs = nestedDocsProvider.childDocs(context);
        if (parentDocs == null || childDocs == null) {
            return geoPointDistanceDocValues;
        }
        SortedNumericDoubleValues sortedNumericDoubleValues = SortedNumericDoubleValues.createDistance(geoPointDistanceDocValues);
        return DocValuesJoin.joinAsSingleValued(sortedNumericDoubleValues, missingValue, parentDocs, childDocs);
    }

    private static SortedDocValues joinAsSingleValued(final SortedDocValues selectedValues, final BitSet parentDocs, final DocIdSetIterator childDocs) {
        Contracts.assertNotNull((Object)parentDocs, (String)"parent docs");
        Contracts.assertNotNull((Object)childDocs, (String)"child docs");
        return new SortedDocValues(){
            int docID = -1;
            int lastSeenParentDoc = 0;
            int lastEmittedOrd = -1;

            public BytesRef lookupOrd(int ord) throws IOException {
                return selectedValues.lookupOrd(ord);
            }

            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return this.lastEmittedOrd != -1;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.docID = this.lastSeenParentDoc = parentDoc;
                this.lastEmittedOrd = DocValuesJoin.pick(selectedValues, childDocs, firstChildDoc, parentDoc, Integer.MAX_VALUE);
                return this.lastEmittedOrd != -1;
            }

            public int docID() {
                return this.docID;
            }

            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }
        };
    }

    private static NumericDocValues joinAsSingleValued(final SortedNumericDocValues values, final long missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs) {
        return new NumericDocValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (parentDoc == 0) {
                    this.lastEmittedValue = missingValue;
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = DocValuesJoin.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, Integer.MAX_VALUE);
                return true;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }

            public long longValue() {
                return this.lastEmittedValue;
            }
        };
    }

    private static NumericDoubleValues joinAsSingleValued(final SortedNumericDoubleValues values, final double missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs) {
        return new NumericDoubleValues(){
            int lastSeenParentDoc = 0;
            double lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = DocValuesJoin.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, Integer.MAX_VALUE);
                return true;
            }

            public double doubleValue() {
                return this.lastEmittedValue;
            }
        };
    }

    private static int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        int ord = Integer.MAX_VALUE;
        boolean hasValue = false;
        int count = 0;
        int doc = startDoc;
        while (doc < endDoc) {
            if (values.advanceExact(doc)) {
                if (++count > maxChildren) break;
                int innerOrd = values.ordValue();
                ord = Math.min(ord, innerOrd);
                hasValue = true;
            }
            doc = docItr.nextDoc();
        }
        return hasValue ? ord : -1;
    }

    private static long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        boolean hasValue = false;
        long minValue = Long.MAX_VALUE;
        int count = 0;
        int doc = startDoc;
        while (doc < endDoc) {
            if (values.advanceExact(doc)) {
                if (++count > maxChildren) break;
                minValue = Math.min(minValue, values.nextValue());
                hasValue = true;
            }
            doc = docItr.nextDoc();
        }
        return hasValue ? minValue : missingValue;
    }

    private static double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        boolean hasValue = false;
        double minValue = Double.POSITIVE_INFINITY;
        int count = 0;
        int doc = startDoc;
        while (doc < endDoc) {
            if (values.advanceExact(doc)) {
                if (++count > maxChildren) break;
                minValue = Math.min(minValue, values.nextValue());
                hasValue = true;
            }
            doc = docItr.nextDoc();
        }
        return hasValue ? minValue : missingValue;
    }
}

