/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.SloppyMath;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.NumericDoubleValues;

public class GeoPointDistanceDocValues
extends NumericDoubleValues {
    private final SortedNumericDocValues values;
    private final double latitude;
    private final double longitude;

    public GeoPointDistanceDocValues(SortedNumericDocValues values, double latitude, double longitude) {
        this.values = values;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double doubleValue() throws IOException {
        long encoded = this.values.nextValue();
        double valueLatitude = GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32)));
        double valueLongitude = GeoEncodingUtils.decodeLongitude((int)((int)encoded));
        return SloppyMath.haversinMeters((double)this.latitude, (double)this.longitude, (double)valueLatitude, (double)valueLongitude);
    }

    public boolean advanceExact(int doc) throws IOException {
        return this.values.advanceExact(doc);
    }
}

