/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryCreationContextImpl;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class IOStrategy {
    private final DirectoryProvider directoryProvider;
    final ThreadPoolProvider threadPoolProvider;
    final FailureHandler failureHandler;

    protected IOStrategy(DirectoryProvider directoryProvider, ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler) {
        this.directoryProvider = directoryProvider;
        this.threadPoolProvider = threadPoolProvider;
        this.failureHandler = failureHandler;
    }

    public IndexAccessorImpl createIndexAccessor(String indexName, EventContext eventContext, Optional<String> shardId, Analyzer analyzer) {
        DirectoryCreationContextImpl context = new DirectoryCreationContextImpl(shardId.isPresent() ? EventContexts.fromShardId((String)shardId.get()) : null, indexName, shardId);
        DirectoryHolder directoryHolder = this.directoryProvider.createDirectoryHolder(context);
        IndexWriterProvider indexWriterProvider = null;
        IndexReaderProvider indexReaderProvider = null;
        try {
            indexWriterProvider = this.createIndexWriterProvider(indexName, eventContext, analyzer, directoryHolder);
            indexReaderProvider = this.createIndexReaderProvider(directoryHolder, indexWriterProvider);
            return new IndexAccessorImpl(eventContext, directoryHolder, indexWriterProvider, indexReaderProvider);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)((SuppressingCloser)new SuppressingCloser((Throwable)e).push(IndexWriterProvider::clear, (Object)indexWriterProvider)).push(IndexReaderProvider::clear, (Object)indexReaderProvider)).push((AutoCloseable)directoryHolder);
            throw e;
        }
    }

    abstract IndexWriterProvider createIndexWriterProvider(String var1, EventContext var2, Analyzer var3, DirectoryHolder var4);

    abstract IndexReaderProvider createIndexReaderProvider(DirectoryHolder var1, IndexWriterProvider var2);
}

