/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.NearRealTimeIndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.reporting.EventContext;

public class NearRealTimeIOStrategy
extends IOStrategy {
    private static final ConfigurationProperty<Integer> COMMIT_INTERVAL = ConfigurationProperty.forKey((String)"io.commit_interval").asInteger().withDefault((Object)0).build();
    private static final ConfigurationProperty<Integer> REFRESH_INTERVAL = ConfigurationProperty.forKey((String)"io.refresh_interval").asInteger().withDefault((Object)0).build();
    private final TimingSource timingSource;
    private final int commitInterval;
    private final int refreshInterval;

    public static NearRealTimeIOStrategy create(ConfigurationPropertySource propertySource, DirectoryProvider directoryProvider, TimingSource timingSource, ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler) {
        int commitInterval = (Integer)COMMIT_INTERVAL.get(propertySource);
        int refreshInterval = (Integer)REFRESH_INTERVAL.get(propertySource);
        return new NearRealTimeIOStrategy(directoryProvider, timingSource, commitInterval, refreshInterval, threadPoolProvider, failureHandler);
    }

    private NearRealTimeIOStrategy(DirectoryProvider directoryProvider, TimingSource timingSource, int commitInterval, int refreshInterval, ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler) {
        super(directoryProvider, threadPoolProvider, failureHandler);
        this.timingSource = timingSource;
        this.commitInterval = commitInterval;
        this.refreshInterval = refreshInterval;
    }

    @Override
    IndexWriterProvider createIndexWriterProvider(String indexName, EventContext eventContext, Analyzer analyzer, DirectoryHolder directoryHolder) {
        if (this.commitInterval != 0) {
            this.timingSource.ensureInitialized();
        }
        return new IndexWriterProvider(indexName, eventContext, directoryHolder, analyzer, this.timingSource, this.commitInterval, this.threadPoolProvider.getThreadProvider(), this.failureHandler);
    }

    @Override
    IndexReaderProvider createIndexReaderProvider(DirectoryHolder directoryHolder, IndexWriterProvider indexWriterProvider) {
        if (this.refreshInterval != 0) {
            this.timingSource.ensureInitialized();
        }
        return new NearRealTimeIndexReaderProvider(indexWriterProvider, this.timingSource, this.refreshInterval);
    }
}

