/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.query.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;

public final class FuzzyQueryBuilder
extends QueryBuilder {
    private final int maxEditDistance;
    private final int prefixLength;

    public FuzzyQueryBuilder(Analyzer analyzer, int maxEditDistance, int prefixLength) {
        super(analyzer);
        this.maxEditDistance = maxEditDistance;
        this.prefixLength = prefixLength;
    }

    protected Query newTermQuery(Term term) {
        return new FuzzyQuery(term, this.maxEditDistance, this.prefixLength);
    }
}

