/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;

public class IndexWriterDelegatorImpl
implements IndexWriterDelegator {
    private final IndexWriter delegate;
    private final TimingSource timingSource;
    private final int commitInterval;
    private long commitExpiration;

    public IndexWriterDelegatorImpl(IndexWriter delegate, TimingSource timingSource, int commitInterval) {
        this.delegate = delegate;
        this.timingSource = timingSource;
        this.commitInterval = commitInterval;
        this.updateCommitExpiration();
    }

    @Override
    public long addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.delegate.addDocuments(docs);
    }

    @Override
    public long updateDocuments(Term term, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.delegate.updateDocuments(term, docs);
    }

    @Override
    public long deleteDocuments(Term term) throws IOException {
        return this.delegate.deleteDocuments(new Term[]{term});
    }

    @Override
    public long deleteDocuments(Query query) throws IOException {
        return this.delegate.deleteDocuments(new Query[]{query});
    }

    @Override
    public void mergeSegments() throws IOException {
        this.delegate.forceMerge(1);
    }

    public void commit() throws IOException {
        this.doCommit();
    }

    public long commitOrDelay() throws IOException {
        long timeToCommit;
        long l = timeToCommit = this.commitInterval == 0 ? 0L : this.commitExpiration - this.timingSource.getMonotonicTimeEstimate();
        if (timeToCommit > 0L) {
            return timeToCommit;
        }
        this.doCommit();
        return 0L;
    }

    public DirectoryReader openReader() throws IOException {
        return DirectoryReader.open((IndexWriter)this.delegate);
    }

    public DirectoryReader openReaderIfChanged(DirectoryReader oldReader) throws IOException {
        return DirectoryReader.openIfChanged((DirectoryReader)oldReader, (IndexWriter)this.delegate);
    }

    void close() throws IOException {
        this.delegate.close();
    }

    private void doCommit() throws IOException {
        this.delegate.commit();
        this.updateCommitExpiration();
    }

    private void updateCommitExpiration() {
        this.commitExpiration = this.commitInterval == 0 ? 0L : this.timingSource.getMonotonicTimeEstimate() + (long)this.commitInterval;
    }
}

