/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public abstract class AbstractLuceneSearchPredicateBuilder
implements SearchPredicateBuilder<LuceneSearchPredicateBuilder>,
LuceneSearchPredicateBuilder {
    private Float boost;
    private boolean constantScore;

    public void boost(float boost) {
        this.boost = Float.valueOf(boost);
    }

    public void constantScore() {
        this.constantScore = true;
    }

    public LuceneSearchPredicateBuilder toImplementation() {
        return this;
    }

    @Override
    public final Query build(LuceneSearchPredicateContext context) {
        Query query = this.doBuild(context);
        if (this.constantScore) {
            query = new ConstantScoreQuery(query);
        }
        if (this.boost != null) {
            query = new BoostQuery(query, this.boost.floatValue());
        }
        return query;
    }

    protected abstract Query doBuild(LuceneSearchPredicateContext var1);
}

