/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Objects;
import java.util.Set;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.GeoPointDistanceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

class LuceneDistanceToFieldProjection
implements LuceneSearchProjection<Double, Double>,
CollectorFactory<GeoPointDistanceCollector> {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private final DistanceCollectorKey collectorKey;

    LuceneDistanceToFieldProjection(Set<String> indexNames, String absoluteFieldPath, String nestedDocumentPath, GeoPoint center, DistanceUnit unit) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedDocumentPath = nestedDocumentPath;
        this.center = center;
        this.unit = unit;
        this.collectorKey = new DistanceCollectorKey(absoluteFieldPath, center);
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireCollector(this);
    }

    @Override
    public Double extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        GeoPointDistanceCollector distanceCollector = context.getCollector(this.collectorKey);
        return this.unit.fromMeters(distanceCollector.getDistance(documentResult.getDocId()));
    }

    @Override
    public Double transform(LoadingResult<?> loadingResult, Double extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append("]");
        return sb.toString();
    }

    @Override
    public GeoPointDistanceCollector createCollector(CollectorExecutionContext context) {
        return new GeoPointDistanceCollector(this.absoluteFieldPath, this.nestedDocumentPath == null ? null : context.createNestedDocsProvider(this.nestedDocumentPath), this.center, context.getMaxDocs());
    }

    @Override
    public CollectorKey<GeoPointDistanceCollector> getCollectorKey() {
        return this.collectorKey;
    }

    private static final class DistanceCollectorKey
    implements CollectorKey<GeoPointDistanceCollector> {
        private final String absoluteFieldPath;
        private final GeoPoint center;

        private DistanceCollectorKey(String absoluteFieldPath, GeoPoint center) {
            this.absoluteFieldPath = absoluteFieldPath;
            this.center = center;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            DistanceCollectorKey other = (DistanceCollectorKey)obj;
            return this.absoluteFieldPath.equals(other.absoluteFieldPath) && this.center.equals(other.center);
        }

        public int hashCode() {
            return Objects.hash(this.absoluteFieldPath, this.center);
        }
    }
}

