/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDistanceToFieldProjection;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneDistanceToFieldProjectionBuilder
implements DistanceToFieldProjectionBuilder {
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final GeoPoint center;
    private DistanceUnit unit = DistanceUnit.METERS;

    public LuceneDistanceToFieldProjectionBuilder(Set<String> indexNames, String absoluteFieldPath, String nestedDocumentPath, GeoPoint center) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedDocumentPath = nestedDocumentPath;
        this.center = center;
    }

    public DistanceToFieldProjectionBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    public SearchProjection<Double> build() {
        return new LuceneDistanceToFieldProjection(this.indexNames, this.absoluteFieldPath, this.nestedDocumentPath, this.center, this.unit);
    }
}

