/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.timeout.impl;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;

public final class DefaultTimingSource
implements TimingSource {
    private static final long INVALID_TIME = -1L;
    private Timer timer = null;
    private volatile long currentTimeApproximation = -1L;

    @Override
    public long getMonotonicTimeEstimate() {
        long currentValue = this.currentTimeApproximation;
        if (currentValue == -1L) {
            throw new IllegalStateException("Timing source was not started");
        }
        return currentValue;
    }

    @Override
    public synchronized void ensureInitialized() {
        if (this.timer == null) {
            this.timer = new Timer("HibernateSearch_QueryTimeoutMonitor", true);
            this.timer.schedule((TimerTask)new TriggerTask(), 5L, 5L);
            this.currentTimeApproximation = DefaultTimingSource.currentTime();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.currentTimeApproximation = -1L;
    }

    private static long currentTime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    private class TriggerTask
    extends TimerTask {
        private TriggerTask() {
        }

        @Override
        public void run() {
            DefaultTimingSource.this.currentTimeApproximation = DefaultTimingSource.currentTime();
        }
    }
}

