/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LongValueFacetCounts;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFacetsBasedTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

public class LuceneNumericTermsAggregation<F, E extends Number, K>
extends AbstractLuceneFacetsBasedTermsAggregation<F, Long, K> {
    private static final Comparator<Long> LONG_COMPARATOR = Comparator.naturalOrder();
    private final AbstractLuceneNumericFieldCodec<F, E> codec;
    private final LuceneNumericDomain<E> numericDomain;

    private LuceneNumericTermsAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.codec = ((Builder)builder).codec;
        this.numericDomain = this.codec.getDomain();
    }

    @Override
    FacetResult getTopChildren(IndexReader reader, FacetsCollector facetsCollector, int limit) throws IOException {
        LongValueFacetCounts facetCounts = this.numericDomain.createTermsFacetCounts(this.absoluteFieldPath, facetsCollector);
        return facetCounts.getTopChildren(limit, this.absoluteFieldPath, new String[0]);
    }

    @Override
    SortedSet<Long> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
        TreeSet<Long> collectedTerms = new TreeSet<Long>(descending ? LONG_COMPARATOR.reversed() : LONG_COMPARATOR);
        for (LeafReaderContext leaf : reader.leaves()) {
            LeafReader atomicReader = leaf.reader();
            NumericDocValues docValues = atomicReader.getNumericDocValues(this.absoluteFieldPath);
            if (docValues == null) continue;
            while (docValues.nextDoc() != Integer.MAX_VALUE) {
                Long term = docValues.longValue();
                collectedTerms.add(term);
                if (collectedTerms.size() <= limit) continue;
                collectedTerms.remove(collectedTerms.last());
            }
        }
        return collectedTerms;
    }

    @Override
    Comparator<Long> getAscendingTermComparator() {
        return LONG_COMPARATOR;
    }

    @Override
    Long labelToTerm(String termAsString) {
        return Long.valueOf(termAsString);
    }

    @Override
    F termToFieldValue(Long term) {
        return this.codec.decode(this.numericDomain.fromDocValue(term));
    }

    public static class Builder<F, E extends Number, K>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractBuilder<F, Long, K> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;

        public Builder(LuceneSearchContext searchContext, String absoluteFieldPath, ProjectionConverter<? super F, ? extends K> fromFieldValueConverter, AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(searchContext, absoluteFieldPath, fromFieldValueConverter);
            this.codec = codec;
        }

        @Override
        public LuceneNumericTermsAggregation<F, E, K> build() {
            return new LuceneNumericTermsAggregation(this);
        }
    }
}

