/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneIntegerDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneByteFieldCodec
extends AbstractLuceneNumericFieldCodec<Byte, Integer> {
    public LuceneByteFieldCodec(boolean projectable, boolean searchable, boolean sortable, boolean aggregable, Byte indexNullAsValue) {
        super(projectable, searchable, sortable, aggregable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Byte value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.intValue()));
    }

    @Override
    public Byte decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        Integer integer = (Integer)field.numericValue();
        return integer.byteValue();
    }

    @Override
    public Integer encode(Byte value) {
        return (int)value;
    }

    @Override
    public Byte decode(Integer encoded) {
        return encoded.byteValue();
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneIntegerDomain.get();
    }
}

