/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;

public final class LuceneStringFieldCodec
implements LuceneTextFieldCodec<String> {
    private final boolean sortable;
    private final boolean searchable;
    private final boolean aggregable;
    private final FieldType fieldType;
    private String indexNullAsValue;
    private final Analyzer analyzerOrNormalizer;

    public LuceneStringFieldCodec(boolean searchable, boolean sortable, boolean aggregable, FieldType fieldType, String indexNullAsValue, Analyzer analyzerOrNormalizer) {
        this.sortable = sortable;
        this.searchable = searchable;
        this.aggregable = aggregable;
        this.fieldType = fieldType;
        this.indexNullAsValue = indexNullAsValue;
        this.analyzerOrNormalizer = analyzerOrNormalizer;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, String value) {
        if (value == null && this.indexNullAsValue != null) {
            value = this.indexNullAsValue;
        }
        if (value == null) {
            return;
        }
        if (this.searchable || this.fieldType.stored()) {
            documentBuilder.addField((IndexableField)new Field(absoluteFieldPath, (CharSequence)value, (IndexableFieldType)this.fieldType));
        }
        if (this.sortable || this.aggregable) {
            BytesRef normalized = this.normalize(absoluteFieldPath, value);
            if (this.sortable) {
                documentBuilder.addField((IndexableField)new SortedDocValuesField(absoluteFieldPath, normalized));
            }
            if (this.aggregable) {
                documentBuilder.addField((IndexableField)new SortedSetDocValuesFacetField(absoluteFieldPath, normalized.utf8ToString()));
            }
        }
        if (!this.sortable && this.fieldType.omitNorms()) {
            documentBuilder.addFieldName(absoluteFieldPath);
        }
    }

    @Override
    public String decode(Document document, String absoluteFieldPath) {
        return document.get(absoluteFieldPath);
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneStringFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneStringFieldCodec other = (LuceneStringFieldCodec)obj;
        return this.sortable == other.sortable && this.searchable == other.searchable && Objects.equals(this.fieldType, other.fieldType);
    }

    @Override
    public Query createExistsQuery(String absoluteFieldPath) {
        if (!this.fieldType.omitNorms()) {
            return new NormsFieldExistsQuery(absoluteFieldPath);
        }
        if (this.sortable) {
            return new DocValuesFieldExistsQuery(absoluteFieldPath);
        }
        return new TermQuery(new Term(MetadataFields.fieldNamesFieldName(), absoluteFieldPath));
    }

    @Override
    public String encode(String value) {
        return value;
    }

    @Override
    public BytesRef normalize(String absoluteFieldPath, String value) {
        if (value == null) {
            return null;
        }
        if (this.analyzerOrNormalizer == null) {
            return new BytesRef((CharSequence)value);
        }
        return this.analyzerOrNormalizer.normalize(absoluteFieldPath, value);
    }
}

