/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsCompositePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactory;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public class LuceneObjectPredicateBuilderFactoryImpl
implements LuceneObjectPredicateBuilderFactory {
    private final Map<String, LuceneFieldPredicateBuilderFactory> leafFields = new HashMap<String, LuceneFieldPredicateBuilderFactory>();

    public LuceneObjectPredicateBuilderFactoryImpl(LuceneIndexModel indexModel, LuceneIndexSchemaObjectNode objectNode) {
        this.addLeafFields(indexModel, objectNode);
    }

    @Override
    public boolean isCompatibleWith(LuceneObjectPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        LuceneObjectPredicateBuilderFactoryImpl casted = (LuceneObjectPredicateBuilderFactoryImpl)other;
        Set<String> absoluteFieldPaths = this.leafFields.keySet();
        if (!absoluteFieldPaths.equals(casted.leafFields.keySet())) {
            return false;
        }
        for (String absoluteFieldPath : absoluteFieldPaths) {
            if (this.leafFields.get(absoluteFieldPath).hasCompatibleCodec(casted.leafFields.get(absoluteFieldPath))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExistsPredicateBuilder<LuceneSearchPredicateBuilder> createExistsPredicateBuilder() {
        LuceneExistsCompositePredicateBuilder objectPredicateBuilder = new LuceneExistsCompositePredicateBuilder();
        for (Map.Entry<String, LuceneFieldPredicateBuilderFactory> entry : this.leafFields.entrySet()) {
            ExistsPredicateBuilder<LuceneSearchPredicateBuilder> existsPredicateBuilder = entry.getValue().createExistsPredicateBuilder(entry.getKey());
            objectPredicateBuilder.addChild((SearchPredicateBuilder<LuceneSearchPredicateBuilder>)existsPredicateBuilder);
        }
        return objectPredicateBuilder;
    }

    private void addLeafFields(LuceneIndexModel indexModel, LuceneIndexSchemaObjectNode objectNode) {
        for (String childPath : objectNode.getChildrenAbsolutePaths()) {
            LuceneIndexSchemaObjectNode innerObjectNode = indexModel.getObjectNode(childPath);
            if (innerObjectNode != null && innerObjectNode.getStorage().equals((Object)ObjectFieldStorage.FLATTENED)) {
                this.addLeafFields(indexModel, innerObjectNode);
                continue;
            }
            LuceneIndexSchemaFieldNode<?> fieldNode = indexModel.getFieldNode(childPath);
            if (fieldNode == null) continue;
            this.leafFields.put(childPath, fieldNode.getPredicateBuilderFactory());
        }
    }
}

