/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class LuceneIndexWorkspace
implements IndexWorkspace {
    private final LuceneWorkFactory factory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final DetachedBackendSessionContext sessionContext;

    public LuceneIndexWorkspace(LuceneWorkFactory factory, WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.factory = factory;
        this.indexManagerContext = indexManagerContext;
        this.sessionContext = sessionContext;
    }

    public CompletableFuture<?> mergeSegments() {
        return this.doSubmit(this.indexManagerContext.getAllWriteOrchestrators(), this.factory.mergeSegments(), DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
    }

    public CompletableFuture<?> purge(Set<String> routingKeys) {
        return this.doSubmit(this.indexManagerContext.getWriteOrchestrators(routingKeys), this.factory.deleteAll(this.sessionContext.getTenantIdentifier(), routingKeys), DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
    }

    public CompletableFuture<?> flush() {
        return this.doSubmit(this.indexManagerContext.getAllWriteOrchestrators(), this.factory.noOp(), DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
    }

    public CompletableFuture<?> refresh() {
        return this.doSubmit(this.indexManagerContext.getAllWriteOrchestrators(), this.factory.noOp(), DocumentCommitStrategy.NONE, DocumentRefreshStrategy.FORCE);
    }

    private CompletableFuture<?> doSubmit(Collection<LuceneWriteWorkOrchestrator> orchestrators, LuceneWriteWork<?> work, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        CompletableFuture[] futures = new CompletableFuture[orchestrators.size()];
        int i = 0;
        for (LuceneWriteWorkOrchestrator orchestrator : orchestrators) {
            futures[i] = orchestrator.submit(work, commitStrategy, refreshStrategy);
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }
}

