/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSingleDocumentWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneUpdateEntryWork
extends AbstractLuceneWriteWork<Long>
implements LuceneSingleDocumentWriteWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;
    private final String id;
    private final Query filter;
    private final LuceneIndexEntry indexEntry;

    LuceneUpdateEntryWork(String tenantId, String id, Query filter, LuceneIndexEntry indexEntry) {
        super("updateEntry");
        this.tenantId = tenantId;
        this.id = id;
        this.filter = filter;
        this.indexEntry = indexEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", tenantId=").append(this.tenantId).append(", entry=").append(this.indexEntry).append("]");
        return sb.toString();
    }

    @Override
    public Long execute(LuceneWriteWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexWriterDelegator();
            Term idTerm = new Term(MetadataFields.idFieldName(), this.id);
            if (this.filter == null) {
                return indexWriterDelegator.updateDocuments(idTerm, this.indexEntry);
            }
            indexWriterDelegator.deleteDocuments(Queries.boolFilter((Query)new TermQuery(idTerm), this.filter));
            return indexWriterDelegator.addDocuments(this.indexEntry);
        }
        catch (IOException e) {
            throw log.unableToIndexEntry(this.tenantId, this.id, context.getEventContext(), e);
        }
    }

    @Override
    public String getDocumentId() {
        return this.id;
    }
}

