/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionCollector;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionContributor;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneAnalysisDefinitionRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Similarity similarity;
    private final Map<String, Analyzer> analyzerDefinitions;
    private final Map<String, Analyzer> normalizerDefinitions;

    public LuceneAnalysisDefinitionRegistry() {
        this.similarity = LuceneAnalysisDefinitionRegistry.createDefaultSimilarity();
        this.analyzerDefinitions = Collections.emptyMap();
        this.normalizerDefinitions = Collections.emptyMap();
    }

    public LuceneAnalysisDefinitionRegistry(LuceneAnalysisDefinitionContributor contributor) {
        this.similarity = contributor.getSimilarity().orElseGet(LuceneAnalysisDefinitionRegistry::createDefaultSimilarity);
        this.analyzerDefinitions = new TreeMap<String, Analyzer>();
        this.normalizerDefinitions = new TreeMap<String, Analyzer>();
        contributor.contribute(new LuceneAnalysisDefinitionCollector(){

            @Override
            public void collectAnalyzer(String name, Analyzer analyzer) {
                Analyzer previous = LuceneAnalysisDefinitionRegistry.this.analyzerDefinitions.putIfAbsent(name, analyzer);
                if (previous != null && previous != analyzer) {
                    throw log.analyzerDefinitionNamingConflict(name);
                }
            }

            @Override
            public void collectNormalizer(String name, Analyzer normalizer) {
                Analyzer previous = LuceneAnalysisDefinitionRegistry.this.normalizerDefinitions.putIfAbsent(name, normalizer);
                if (previous != null && previous != normalizer) {
                    throw log.normalizerDefinitionNamingConflict(name);
                }
            }
        });
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzerDefinition(String name) {
        return this.analyzerDefinitions.get(name);
    }

    public Analyzer getNormalizerDefinition(String name) {
        return this.normalizerDefinitions.get(name);
    }

    private static Similarity createDefaultSimilarity() {
        return new BM25Similarity();
    }
}

