/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneFlattenedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneNestedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneDocumentBuilder
implements LuceneDocumentBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final LuceneIndexModel model;
    protected final LuceneIndexSchemaObjectNode schemaNode;
    private List<LuceneFlattenedObjectDocumentBuilder> flattenedObjectDocumentBuilders;
    private List<LuceneNestedObjectDocumentBuilder> nestedObjectDocumentBuilders;

    AbstractLuceneDocumentBuilder(LuceneIndexModel model, LuceneIndexSchemaObjectNode schemaNode) {
        this.model = model;
        this.schemaNode = schemaNode;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        LuceneIndexFieldReference luceneFieldReference = (LuceneIndexFieldReference)fieldReference;
        LuceneIndexSchemaFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.addValue(fieldSchemaNode, value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        LuceneIndexSchemaObjectFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        return this.addObject(fieldSchemaNode, false);
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        LuceneIndexSchemaObjectFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.addObject(fieldSchemaNode, true);
    }

    public void addValue(String relativeFieldName, Object value) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        LuceneIndexSchemaFieldNode<?> node = this.model.getFieldNode(absoluteFieldPath, IndexFieldFilter.ALL);
        if (node == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        this.addValueUnknownType(node, value);
    }

    public DocumentElement addObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        LuceneIndexSchemaObjectFieldNode fieldSchemaNode = this.model.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        return this.addObject(fieldSchemaNode, false);
    }

    public void addNullObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        LuceneIndexSchemaObjectFieldNode fieldSchemaNode = this.model.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.getEventContext());
        }
        this.addObject(fieldSchemaNode, true);
    }

    abstract void checkNoValueYetForSingleValued(String var1);

    private void addNestedObjectDocumentBuilder(LuceneNestedObjectDocumentBuilder nestedObjectDocumentBuilder) {
        if (this.nestedObjectDocumentBuilders == null) {
            this.nestedObjectDocumentBuilders = new ArrayList<LuceneNestedObjectDocumentBuilder>();
        }
        this.nestedObjectDocumentBuilders.add(nestedObjectDocumentBuilder);
    }

    private void addFlattenedObjectDocumentBuilder(LuceneFlattenedObjectDocumentBuilder flattenedObjectDocumentBuilder) {
        if (this.flattenedObjectDocumentBuilders == null) {
            this.flattenedObjectDocumentBuilders = new ArrayList<LuceneFlattenedObjectDocumentBuilder>();
        }
        this.flattenedObjectDocumentBuilders.add(flattenedObjectDocumentBuilder);
    }

    private void checkTreeConsistency(LuceneIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidFieldForDocumentElement(expectedParentNode.absolutePath(), this.schemaNode.absolutePath());
        }
    }

    void contribute(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String routingKey, String rootId, List<Document> nestedDocuments) {
        if (this.flattenedObjectDocumentBuilders != null) {
            for (LuceneFlattenedObjectDocumentBuilder flattenedObjectDocumentBuilder : this.flattenedObjectDocumentBuilders) {
                flattenedObjectDocumentBuilder.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
            }
        }
        if (this.nestedObjectDocumentBuilders != null) {
            for (LuceneNestedObjectDocumentBuilder nestedObjectDocumentBuilder : this.nestedObjectDocumentBuilders) {
                nestedObjectDocumentBuilder.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
            }
        }
    }

    private <F> void addValue(LuceneIndexSchemaFieldNode<F> node, F value) {
        LuceneIndexSchemaObjectNode expectedParentNode = node.parent();
        this.checkTreeConsistency(expectedParentNode);
        IndexValueFieldTypeDescriptor type = node.type();
        String absolutePath = node.absolutePath();
        if (!node.isMultiValued()) {
            this.checkNoValueYetForSingleValued(absolutePath);
        }
        type.getCodec().encode(this, absolutePath, value);
    }

    private DocumentElement addObject(LuceneIndexSchemaObjectFieldNode node, boolean nullObject) {
        LuceneIndexSchemaObjectNode expectedParentNode = node.parent();
        this.checkTreeConsistency(expectedParentNode);
        String absolutePath = node.absolutePath();
        if (!node.isMultiValued()) {
            this.checkNoValueYetForSingleValued(absolutePath);
        }
        if (nullObject) {
            return NoOpDocumentElement.get();
        }
        switch (node.getStorage()) {
            case NESTED: {
                LuceneNestedObjectDocumentBuilder nestedDocumentBuilder = new LuceneNestedObjectDocumentBuilder(this.model, node);
                this.addNestedObjectDocumentBuilder(nestedDocumentBuilder);
                return nestedDocumentBuilder;
            }
        }
        LuceneFlattenedObjectDocumentBuilder flattenedDocumentBuilder = new LuceneFlattenedObjectDocumentBuilder(this.model, node, this);
        this.addFlattenedObjectDocumentBuilder(flattenedDocumentBuilder);
        return flattenedDocumentBuilder;
    }

    private void addValueUnknownType(LuceneIndexSchemaFieldNode<?> node, Object value) {
        if (value == null) {
            this.addValue(node, null);
        } else {
            LuceneIndexSchemaFieldNode<?> typeCheckedNode = node.withValueType(value.getClass(), this.model.getEventContext());
            this.addValue(typeCheckedNode, value);
        }
    }
}

