/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexSchemaFieldNode<F>
extends AbstractLuceneIndexSchemaFieldNode
implements IndexValueFieldDescriptor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<String> nestedPathHierarchy;
    private final LuceneIndexFieldType<F> type;

    public LuceneIndexSchemaFieldNode(LuceneIndexSchemaObjectNode parent, String relativeName, IndexFieldInclusion inclusion, boolean multiValued, LuceneIndexFieldType<F> type) {
        super(parent, relativeName, inclusion, multiValued);
        this.nestedPathHierarchy = parent.getNestedPathHierarchy();
        this.type = type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absolutePath=" + this.absolutePath + ", type=" + this.type + "]";
    }

    public boolean isObjectField() {
        return false;
    }

    public boolean isValueField() {
        return true;
    }

    @Override
    public LuceneIndexSchemaObjectFieldNode toObjectField() {
        throw log.invalidIndexElementTypeValueFieldIsNotObjectField(this.absolutePath);
    }

    @Override
    public LuceneIndexSchemaFieldNode<F> toValueField() {
        return this;
    }

    public String getNestedDocumentPath() {
        return this.nestedPathHierarchy.isEmpty() ? null : this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    public LuceneIndexFieldType<F> type() {
        return this.type;
    }

    public <T> LuceneIndexSchemaFieldNode<? super T> withValueType(Class<T> expectedSubType, EventContext eventContext) {
        if (!this.type.getValueType().isAssignableFrom(expectedSubType)) {
            throw log.invalidFieldValueType(this.type.getValueType(), expectedSubType, eventContext.append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath)));
        }
        return this;
    }
}

