/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateSearchMultiReader
extends MultiReader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<DirectoryReader> directoryReaders;
    private final IndexReaderMetadataResolver metadataResolver;

    public static HibernateSearchMultiReader open(Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys) {
        if (indexManagerContexts.isEmpty()) {
            return null;
        }
        Builder builder = new Builder();
        try {
            for (ReadIndexManagerContext readIndexManagerContext : indexManagerContexts) {
                readIndexManagerContext.openIndexReaders(routingKeys, builder);
            }
            return builder.build();
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll((Iterable)builder.directoryReaders);
            throw log.failureOnMultiReaderRefresh(EventContexts.fromIndexNames(indexNames), e);
        }
    }

    HibernateSearchMultiReader(List<DirectoryReader> directoryReaders, IndexReaderMetadataResolver metadataResolver) throws IOException {
        super(HibernateSearchMultiReader.toReaderArray(directoryReaders), true);
        this.directoryReaders = directoryReaders;
        this.metadataResolver = metadataResolver;
    }

    public IndexReaderMetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    protected synchronized void doClose() throws IOException {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debugf("Closing MultiReader: %s", (Object)this);
        }
        try (Closer closer = new Closer();){
            closer.pushAll(IndexReader::decRef, this.directoryReaders);
        }
        if (debugEnabled) {
            log.trace("MultiReader closed.");
        }
    }

    private static IndexReader[] toReaderArray(List<DirectoryReader> directoryReaders) {
        return (IndexReader[])directoryReaders.toArray(new DirectoryReader[0]);
    }

    public static class Builder
    implements DirectoryReaderCollector {
        private final List<DirectoryReader> directoryReaders = new ArrayList<DirectoryReader>();
        private final Map<DirectoryReader, String> mappedTypeNameByDirectoryReader = new HashMap<DirectoryReader, String>();

        private Builder() {
        }

        @Override
        public void collect(String mappedTypeName, DirectoryReader directoryReader) {
            this.directoryReaders.add(directoryReader);
            this.mappedTypeNameByDirectoryReader.put(directoryReader, mappedTypeName);
        }

        HibernateSearchMultiReader build() throws IOException {
            IndexReaderMetadataResolver metadataResolver = new IndexReaderMetadataResolver(this.mappedTypeNameByDirectoryReader);
            return new HibernateSearchMultiReader(this.directoryReaders, metadataResolver);
        }
    }
}

